;**********************************************************************
;   Copyright (C) 2005,2006,2007 Dwayne Forsyth
;                                 
;   This program is free software; you can redistribute it and/or
;   modify it under the terms of the GNU General Public License
;   as published by the Free Software Foundation; either version 2
;   of the License, or (at your option) any later version.
; 
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the
; 
;      Free Software Foundation, Inc.
;      51 Franklin Street, Fifth Floor
;      Boston, MA  02110-1301, USA.
;
;**********************************************************************
;
; A number of these tables were created by Dave Holle
;


;**********************************************************************
; Cops (Dwayne Forsyth)
;**********************************************************************
    start_pattern 3, 0x07
;           R  G        B   D
    dt  b'11000000',b'00000000' ; 
    dt  b'00000000',b'00000000' ; 
    dt  b'11000000',b'00000000' ; 
    dt  b'00000000',b'00000001' ; 
    dt  b'00000000',b'11000000' ; 
    dt  b'00000000',b'00000000' ; 
    dt  b'00000000',b'11000000' ; 
    dt  b'00000000',b'00001111' ; 
    dt  b'00110000',b'00000000' ; 
    dt  b'00000000',b'00000000' ; 
    dt  b'00110000',b'00000000' ; 
    dt  b'00000000',b'00000001' ; 
    dt  b'00000000',b'00110000' ; 
    dt  b'00000000',b'00000000' ; 
    dt  b'00000000',b'00110000' ; 
    dt  b'00000000',b'00001111' ; 
   end_pattern

;**********************************************************************
; For testing the LEDs. (Dwayne Forsyth)
;**********************************************************************
   start_pattern 3, 0x20
;           R   G      B
    dt  b'10000000',b'00000000' ; 
    dt  b'01000000',b'00000000' ; 
    dt  b'00100000',b'00000000' ; 
    dt  b'00010000',b'00000000' ; 
    dt  b'00000000',b'00000111' ; 
    dt  b'00001000',b'00000000' ; 
    dt  b'00000100',b'00000000' ; 
    dt  b'00000010',b'00000000' ; 
    dt  b'00000001',b'00000000' ; 
    dt  b'00000000',b'00000111' ; 
    dt  b'00000000',b'10000000' ; 
    dt  b'00000000',b'01000000' ; 
    dt  b'00000000',b'00100000' ; 
    dt  b'00000000',b'00010000' ; 
    dt  b'00000000',b'00001111' ; 

    end_pattern


;**********************************************************************
; fade in/out: white, red, green, blue, yellow, cyan, violet (Dave Holle)
;**********************************************************************
   start_pattern 1, 0x80
;            R           G           B
    dt  b'00000000',b'00000000',b'00000000' ; 0/3
    dt  b'01010101',b'01010101',b'01010101' ; 1/3 all LEDs
    dt  b'10101010',b'10101010',b'10101010' ; 2/3 all LEDs
    dt  b'11111111',b'11111111',b'11111111' ; 3/3 all LEDs
    dt  b'10101010',b'10101010',b'10101010' ; 2/3 all LEDs;
    dt  b'01010101',b'01010101',b'01010101' ; 1/3 all LEDs
    dt  b'00000000',b'00000000',b'00000000' ; 0/3
    dt  b'01010101',b'00000000',b'00000000' ; 1/3 all RED LEDs
    dt  b'10101010',b'00000000',b'00000000' ; 2/3 all RED LEDs
    dt  b'11111111',b'00000000',b'00000000' ; 3/3 all RED LEDs
    dt  b'10101010',b'00000000',b'00000000' ; 2/3 all RED LEDs
    dt  b'01010101',b'00000000',b'00000000' ; 1/3 all RED LEDs
    dt  b'00000000',b'00000000',b'00000000' ; 0/3
    dt  b'00000000',b'01010101',b'00000000' ; 1/3 all GREEN LEDs
    dt  b'00000000',b'10101010',b'00000000' ; 2/3 all GREEN LEDs
    dt  b'00000000',b'11111111',b'00000000' ; 3/3 all GREEN LEDs
    dt  b'00000000',b'10101010',b'00000000' ; 2/3 all GREEN LEDs
    dt  b'00000000',b'01010101',b'00000000' ; 1/3 all GREEN LEDs
    dt  b'00000000',b'00000000',b'00000000' ; 0/3
    dt  b'00000000',b'00000000',b'01010101' ; 1/3 all BLUE LEDs
    dt  b'00000000',b'00000000',b'10101010' ; 2/3 all BLUE LEDs
    dt  b'00000000',b'00000000',b'11111111' ; 3/3 all BLUE LEDs
    dt  b'00000000',b'00000000',b'10101010' ; 2/3 all BLUE LEDs
    dt  b'00000000',b'00000000',b'01010101' ; 1/3 all BLUE LEDs
    dt  b'00000000',b'00000000',b'00000000' ; 0/3
    dt  b'01010101',b'01010101',b'00000000' ; 1/3 all RED & GREEN LEDs
    dt  b'10101010',b'10101010',b'00000000' ; 2/3 all RED & GREEN LEDs
    dt  b'11111111',b'11111111',b'00000000' ; 3/3 all RED & GREEN LEDs
    dt  b'10101010',b'10101010',b'00000000' ; 2/3 all RED & GREEN LEDs
    dt  b'01010101',b'01010101',b'00000000' ; 1/3 all RED & GREEN LEDs
    dt  b'00000000',b'00000000',b'00000000' ; 0/3
    dt  b'00000000',b'01010101',b'01010101' ; 1/3 all GREEN & BLUE LEDs
    dt  b'00000000',b'10101010',b'10101010' ; 2/3 all GREEN & BLUE LEDs
    dt  b'00000000',b'11111111',b'11111111' ; 3/3 all GREEN & BLUE LEDs
    dt  b'00000000',b'10101010',b'10101010' ; 2/3 all GREEN & BLUE LEDs
    dt  b'00000000',b'01010101',b'01010101' ; 1/3 all GREEN & BLUE LEDs
    dt  b'00000000',b'00000000',b'00000000' ; 0/3
    dt  b'01010101',b'00000000',b'01010101' ; 1/3 all BLUE & RED LEDs
    dt  b'10101010',b'00000000',b'10101010' ; 2/3 all BLUE & RED LEDs
    dt  b'11111111',b'00000000',b'11111111' ; 3/3 all BLUE & RED LEDs
    dt  b'10101010',b'00000000',b'10101010' ; 2/3 all BLUE & RED LEDs
    dt  b'01010101',b'00000000',b'01010101' ; 1/3 all BLUE & RED LEDs
    end_pattern

;**********************************************************************
; march colors back and forth (Dave Holle)
;**********************************************************************
    start_pattern 3, 0x30
;            R           G           B
    dt  b'10000000',b'00000000' ; R___ red marches L to R
    dt  b'01000000',b'00000000' ; _R__
    dt  b'00100000',b'00000000' ; __R_
    dt  b'00010000',b'00000000' ; ___R
    dt  b'00010001',b'00000000' ; ___Y yellow marches R to L
    dt  b'00100010',b'00000000' ; __Y_
    dt  b'01000100',b'00000000' ; _Y__
    dt  b'10001000',b'00000000' ; Y___
    dt  b'00001000',b'00000000' ; G___ green marches L to R
    dt  b'00000100',b'00000000' ; _G__
    dt  b'00000010',b'00000000' ; __G_
    dt  b'00000001',b'00000000' ; ___G
    dt  b'00000001',b'00010000' ; ___C cyan marches R to L
    dt  b'00000010',b'00100000' ; __C_
    dt  b'00000100',b'01000000' ; _C__
    dt  b'00001000',b'10000000' ; C___
    dt  b'00000000',b'10000000' ; B___ blue marches L to R
    dt  b'00000000',b'01000000' ; _B__
    dt  b'00000000',b'00100000' ; __B_
    dt  b'00000000',b'00010000' ; ___B
    dt  b'00010000',b'00010000' ; ___V violet marches R to L
    dt  b'00100000',b'00100000' ; __V_
    dt  b'01000000',b'01000000' ; _V__
    dt  b'10000000',b'10000000' ; V___
   end_pattern

;**********************************************************************
; marching R,G,B sequence (Dave Holle)
;**********************************************************************
    start_pattern 3, 0x30
;            R           G           B
    dt  b'00000000',b'10000000' ; B___
    dt  b'00001000',b'01000000' ; GB__
    dt  b'10000100',b'00100000' ; RGB_
    dt  b'01000010',b'00010000' ; _RGB
    dt  b'00100001',b'00000000' ; __RG
    dt  b'00010000',b'00000000' ; ___R
    dt  b'00000000',b'00000000' ; ____
    dt  b'00010000',b'00000000' ; ___R
    dt  b'00100001',b'00000000' ; __RG
    dt  b'01000010',b'00010000' ; _RGB
    dt  b'10000100',b'00100000' ; RGB_
    dt  b'00001000',b'01000000' ; GB__
    dt  b'00000000',b'10000000' ; B___
    dt  b'00000000',b'00000000' ; ____
   end_pattern

;**********************************************************************
; triple crosser (Dave Holle)
;**********************************************************************
    start_pattern 3, 0x30
;            R           G           B
    dt  b'10000000',b'00100100' ;RBG_
    dt  b'01000000',b'01000010' ;_YB_   Y = R+G
    dt  b'00100000',b'10000001' ;G_RB
    dt  b'00010000',b'01000010' ;_GBR
    dt  b'00100000',b'00100100' ;_BY_
    dt  b'01000000',b'00011000' ;BR_G
   end_pattern

;**********************************************************************
; mars lite (Dave Holle)
;**********************************************************************
    start_pattern 3, 0x22
;            R           G           B
    dt  b'10000000',b'00010000' ;R__B
    dt  b'01000000',b'00100000' ;_RB_
    dt  b'00100000',b'01000000' ;_BR_
    dt  b'00010000',b'10000000' ;B__R
    dt  b'00010000',b'10000000' ;B__R
    dt  b'00100000',b'01000000' ;_BR_
    dt  b'01000000',b'00100000' ;_RB_
    dt  b'10000000',b'00010000' ;R__B
   end_pattern

;**********************************************************************
; xmas? (Dave Holle)
;**********************************************************************
    start_pattern 3, 0x22
;            R           G           B
    dt  b'10100101',b'00000000' ;RGRG
    dt  b'01011010',b'00000000' ;GRGR
   end_pattern

;**********************************************************************
; Ward's 3 bears (Dave Holle)
;**********************************************************************
    start_pattern 1, 0x22
;        R           G           B
    dt b'01000000',b'00000000',b'00000000'
    dt b'10000000',b'00000000',b'00000000'
    dt b'11000000',b'00000000',b'00000000'
    dt b'10000000',b'00000000',b'00000000'
    dt b'01100000',b'00000000',b'00000000'
    dt b'00100000',b'00000000',b'00000000'
    dt b'00110000',b'00000000',b'00000000'
    dt b'00100100',b'00000000',b'00000000'
    dt b'00011000',b'00000000',b'00000000'
    dt b'00001100',b'00000000',b'00000000'
    dt b'00001000',b'00000000',b'00000000'
    dt b'00000101',b'00000000',b'00000000'
    dt b'00000010',b'00000000',b'00000000'
    dt b'00000011',b'00000000',b'00000000'
    dt b'00000010',b'00000000',b'00000000'
    dt b'00000001',b'00000000',b'00000000'
    dt b'00000000',b'11000000',b'00000000'
    dt b'00000000',b'11000000',b'00000000'
    dt b'00000000',b'11000000',b'00000000'
    dt b'00000000',b'00110000',b'00000000'
    dt b'00000000',b'00110000',b'00000000'
    dt b'00000000',b'00110000',b'00000000'
    dt b'00000000',b'00001100',b'00000000'
    dt b'00000000',b'00001100',b'00000000'
    dt b'00000000',b'00001100',b'00000000'
    dt b'00000000',b'00000011',b'00000000'
    dt b'00000000',b'00000011',b'00000000'
    dt b'00000000',b'00000011',b'00000000'
    dt b'00000000',b'00000000',b'11000000'
    dt b'00000000',b'00000000',b'00110000'
    dt b'00000000',b'00000000',b'00001100'
    dt b'00000000',b'00000000',b'00000011'
   end_pattern

;**********************************************************************
; Ward's walking b'11' (Dave Holle)
;**********************************************************************
    start_pattern 1, 0x30
;        R           G           B
    dt b'11000000',b'00000000',b'00000000'
    dt b'01100000',b'00000000',b'00000000'
    dt b'00110000',b'00000000',b'00000000'
    dt b'00011000',b'00000000',b'00000000'
    dt b'00001100',b'00000000',b'00000000'
    dt b'00000110',b'00000000',b'00000000'
    dt b'00000011',b'00000000',b'00000000'
    dt b'00000001',b'10000000',b'00000000'
    dt b'00000000',b'11000000',b'00000000'
    dt b'00000000',b'01100000',b'00000000'
    dt b'00000000',b'00110000',b'00000000'
    dt b'00000000',b'00011000',b'00000000'
    dt b'00000000',b'00001100',b'00000000'
    dt b'00000000',b'00000110',b'00000000'
    dt b'00000000',b'00000011',b'00000000'
    dt b'00000000',b'00000001',b'10000000'
    dt b'00000000',b'00000000',b'11000000'
    dt b'00000000',b'00000000',b'01100000'
    dt b'00000000',b'00000000',b'00110000'
    dt b'00000000',b'00000000',b'00011000'
    dt b'00000000',b'00000000',b'00001100'
    dt b'00000000',b'00000000',b'00000110'
    dt b'00000000',b'00000000',b'00000011'
    dt b'00000000',b'00000000',b'00000011'
    dt b'00000000',b'00000000',b'00000110'
    dt b'00000000',b'00000000',b'00001100'
    dt b'00000000',b'00000000',b'00011000'
    dt b'00000000',b'00000000',b'00110000'
    dt b'00000000',b'00000000',b'01100000'
    dt b'00000000',b'00000000',b'11000000'
    dt b'00000000',b'00000001',b'10000000'
    dt b'00000000',b'00000011',b'00000000'
    dt b'00000000',b'00000110',b'00000000'
    dt b'00000000',b'00001100',b'00000000'
    dt b'00000000',b'00011000',b'00000000'
    dt b'00000000',b'00110000',b'00000000'
    dt b'00000000',b'01100000',b'00000000'
    dt b'00000000',b'11000000',b'00000000'
    dt b'00000001',b'10000000',b'00000000'
    dt b'00000011',b'00000000',b'00000000'
    dt b'00000110',b'00000000',b'00000000'
    dt b'00001100',b'00000000',b'00000000'
    dt b'00011000',b'00000000',b'00000000'
    dt b'00110000',b'00000000',b'00000000'
    dt b'01100000',b'00000000',b'00000000'
    dt b'11000000',b'00000000',b'00000000'
   end_pattern

;**********************************************************************
; fade across (Dave Holle)
;**********************************************************************
    start_pattern 1, 0x30
;            R           G           B
    dt  b'01000000',b'00000010',b'00001001'
    dt  b'10000000',b'00000001',b'00000110'
    dt  b'11000000',b'00000000',b'00000011'
    dt  b'10010000',b'01000000',b'00000010'
    dt  b'01100000',b'10000000',b'00000001'
    dt  b'00110000',b'11000000',b'00000000'
    dt  b'00100100',b'10010000',b'01000000'
    dt  b'00011000',b'01100000',b'10000000'
    dt  b'00001100',b'00110000',b'11000000'
    dt  b'00001001',b'00100100',b'10010000'
    dt  b'00000110',b'00011000',b'01100000'
    dt  b'00000011',b'00001100',b'00110000'
    dt  b'00000010',b'00001001',b'00100100'
    dt  b'00000001',b'00000110',b'00011000'
    dt  b'00000000',b'00000011',b'00001100'
   end_pattern

;**********************************************************************
; march colors move side to side with a dim trail (Dave Holle)
;**********************************************************************
    start_pattern 1, 0x30
;            R           G           B
    dt  b'11000000',b'00000000',b'00000000' ; R___ red marches L to R
    dt  b'01110000',b'00000000',b'00000000' ; rR__
    dt  b'01011100',b'00000000',b'00000000' ; rrR_
    dt  b'00010111',b'00000000',b'00000000' ; _rrR
    dt  b'00000101',b'00000000',b'00000000' ; __rr
    dt  b'00000001',b'00000000',b'00000000' ; ___r
    dt  b'00000011',b'00000000',b'00000000' ; ___R
    dt  b'00001101',b'00000000',b'00000000' ; __Rr
    dt  b'00110101',b'00000000',b'00000000' ; _Rrr
    dt  b'11010100',b'00000000',b'00000000' ; Rrr_
    dt  b'01010000',b'00000000',b'00000000' ; rr__
    dt  b'01000000',b'00000000',b'00000000' ; r___
    dt  b'00000000',b'11000000',b'00000000' ; G___ green marches L to R
    dt  b'00000000',b'01110000',b'00000000' ; gG__
    dt  b'00000000',b'01011100',b'00000000' ; ggG_
    dt  b'00000000',b'00011011',b'00000000' ; _ggG
    dt  b'00000000',b'00000101',b'00000000' ; __gg
    dt  b'00000000',b'00000001',b'00000000' ; ___g
    dt  b'00000000',b'00000011',b'00000000' ; ___G
    dt  b'00000000',b'00001101',b'00000000' ; __Gg
    dt  b'00000000',b'00110101',b'00000000' ; _Ggg
    dt  b'00000000',b'11010100',b'00000000' ; Ggg_
    dt  b'00000000',b'01010000',b'00000000' ; gg__
    dt  b'00000000',b'01000000',b'00000000' ; g___
    dt  b'00000000',b'00000000',b'11000000' ; B___ blue marches L to R
    dt  b'00000000',b'00000000',b'01110000' ; bB__
    dt  b'00000000',b'00000000',b'01011100' ; bbB_
    dt  b'00000000',b'00000000',b'00011011' ; _bbB
    dt  b'00000000',b'00000000',b'00000101' ; __bb
    dt  b'00000000',b'00000000',b'00000001' ; ___b
    dt  b'00000000',b'00000000',b'00000011' ; ___B
    dt  b'00000000',b'00000000',b'00001101' ; __Bb
    dt  b'00000000',b'00000000',b'00110101' ; _Bbb
    dt  b'00000000',b'00000000',b'11010100' ; Bbb_
    dt  b'00000000',b'00000000',b'01010000' ; bb__
    dt  b'00000000',b'00000000',b'01000000' ; b___
   end_pattern

;**********************************************************************
; fader (Dwayne Forsyth)
;**********************************************************************
   start_pattern 2, 0x07
   end_pattern

;**********************************************************************
; fader (Dwayne Forsyth)
;**********************************************************************
   start_pattern 4, 0x07
   end_pattern

;**********************************************************************
; EEPROM    ;test pattern for 4RGB with 2 bits of luminance per LED (Dave Holle)
;**********************************************************************
    org 0x2100      ; data EEPROM location
;
; Because there are no extra bits in the LED buffer to use as an
; end-of-pattern flag, the pattern table header has a length byte.
;
    de  0x01,0x30,(endpat0-$)/3   ;tbltype1,speed,length

;            R           G           B
    de  b'11111111',b'00011011',b'00000000' ; red -> yellow
    de  b'11111110',b'01101111',b'00000000'
    de  b'11111001',b'10111111',b'00000000'
    de  b'11100100',b'11111111',b'00000000' ; yellow -> green
    de  b'10010000',b'11111111',b'00000001'
    de  b'01000000',b'11111111',b'00000110'
    de  b'00000000',b'11111111',b'00011011' ; green -> cyan
    de  b'00000000',b'11111110',b'01101111'
    de  b'00000000',b'11111001',b'10111111'
    de  b'00000000',b'11100100',b'11111111' ; cyan -> blue
    de  b'00000001',b'10010000',b'11111111'
    de  b'00000110',b'01000000',b'11111111'
    de  b'00011011',b'00000000',b'11111111' ; blue -> violet
    de  b'01101111',b'00000000',b'11111110'
    de  b'10111111',b'00000000',b'11111001'
    de  b'11111111',b'00000000',b'11100100' ; violet -> red
    de  b'11111111',b'00000001',b'10010000'
    de  b'11111111',b'00000110',b'01000000'
endpat0

