;    list p=12f683,b=4,n=0   ; declare processor, tabs, and lines/page
    
;**********************************************************************
;   Copyright (C) 2005,2006,2007 Dwayne Forsyth
;                                 
;   This program is free software; you can redistribute it and/or
;   modify it under the terms of the GNU General Public License
;   as published by the Free Software Foundation; either version 2
;   of the License, or (at your option) any later version.
; 
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the
; 
;      Free Software Foundation, Inc.
;      51 Franklin Street, Fifth Floor
;      Boston, MA  02110-1301, USA.
;
;**********************************************************************
;
;   This is a merger of a number of Blinkie programs I created for different
;   www.2DKits.com boards. The current goal of this code is to support all
;   the 12F683 based boards, and then eventually adding of the 16F688 boards.
;
;   4RBG /w common anode (ufo and clear 5mm) .... Working
;   4RBG /w common Cathode (milk 5mm) ........... Working
;   6 BI /w bi-color LEDs. ...................... Working
;   6 BI /w mono LEDs. .......................... Working
;                                                 - want to add brightness patterns
;   badge 6 bi-color plus 1 mono, no IR ......... Working
;                                                 - disable IR code?
;   badge 7 LED /w mono LEDs, no IR ............. Working
;                                                 - want to update patterns
;                                                 - disable IR code?
;   19 LED Stick ................................ Working
;   
;   Dwayne Forsyth wrote the original code, Dwayne pulled a number of updates,
;   code cleanup, and patterns from Dave Holle.
;                                                                     
;**********************************************************************
;                                                                     
;    Filename:      generic_683.asm                                         
;    Date:          04/05/2007                                 
;                                                         
;    Author:  Dwayne Forsyth
;    email:   Dwayne@2DKits.com                                         
;    Company: www.2DKits.com
;             502 Rue Orleanais
;             Deer Park, IL 60010    
;
;    Help from: Dave Holle <dav@serve-o-matic.com>
;               7N204 Parkside Ave
;               Itasca, IL 60143                              
;                                                                      
;**********************************************************************

    errorlevel  -302                ; suppress banking messages
    __CONFIG _CP_OFF & _CPD_OFF & _BOD_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _FCMEN_OFF & _IESO_OFF

; '__CONFIG' directive is used to embed configuration data within .asm file.
; The labels following the directive are located in the respective .inc file.
; See respective data sheet for additional information on configuration word.

; #define SIM_DEBUG

;*********************************
; 4RBG /w common anode (ufo and clear 5mm)
;*********************************
;#define RGB4
;#define PATTERN1
;#define PATTERN2
;#define PATTERN3
;#define PATTERN4
;#define DISPLAY_1BIT_C
;#define DISPLAY_2BIT_C
;#define ENABLE_IR
;#include    <P12F683.inc>       ; processor specific variable definitions
; LIST P=PIC12F683
;NUM_TAB     equ d'14'   ;highest pattern table number

;*********************************
; 4RBG /w common Cathode (milk 5mm)
;*********************************
;#define RGB4
;#define Common_Cathode
;#define PATTERN1
;#define PATTERN2
;#define PATTERN3
;#define PATTERN4
;#define DISPLAY_1BIT_C
;#define DISPLAY_2BIT_C
;#define ENABLE_IR
;#include    <P12F683.inc>       ; processor specific variable definitions
; LIST P=PIC12F683
; NUM_TAB     equ d'14'   ;highest pattern table number

;*********************************
; 6 BI /w bi-color LEDs.
;*********************************
;#define BI6
;#define BIN2LED
;#define PATTERN1
;#define PATTERN3
;#define DISPLAY_1BIT_C
;#define DISPLAY_2BIT_C
;#define ENABLE_IR
;#include    <P12F683.inc>       ; processor specific variable definitions
; LIST P=PIC12F683
; NUM_TAB     equ d'14'   ;highest pattern table number

;*********************************
; 6 BI /w mono LEDs.
;*********************************
;#define BI6
;#define MONO
;#define FLIPBYTE
;#define PATTERN5
;#define PATTERN11
;#define DISPLAY_1BIT_A
;#define DISPLAY_2BIT_A
;#define ENABLE_IR
;#include    <P12F683.inc>       ; processor specific variable definitions
; LIST P=PIC12F683
;NUM_TAB     equ d'17'   ;highest pattern table number

;*********************************
; badge 6 bi-color plus 1 mono LEDs.
;*********************************
;#define BI6
;#define BIN2LED
;#define PATTERN10
;#define PATTERN3
;#define BADGE
;#define DISPLAY_1BIT_C
;#define DISPLAY_2BIT_C
;#include    <P12F683.inc>       ; processor specific variable definitions
; LIST P=PIC12F683
;NUM_TAB     equ d'14'   ;highest pattern table number

;*********************************
; badge 6 mono LEDs.
;*********************************
#define BI6
#define MONO
#define BADGE
#define PATTERN5
#define PATTERN11
#define FLIPBYTE
#define DISPLAY_1BIT_A
#define DISPLAY_2BIT_A
#include    <P12F683.inc>       ; processor specific variable definitions
 LIST P=PIC12F683
NUM_TAB     equ d'19'   ;highest pattern table number

#define DREW  ; special pattern in EEProm for Drew

;*********************************
; 19 LED Stick
;*********************************
;#define S19
;#define PATTERN6
;#define PATTERN7
;#define PATTERN8
;#define FLIPBYTE
;#define DISPLAY_1BIT_D
;#define ENABLE_IR
;#include    <P12F683.inc>       ; processor specific variable definitions
; LIST P=PIC12F683
;NUM_TAB     equ d'23'   ;highest pattern table number

;*********************************
; 19 Circle bicolor 
;*********************************
;#define C19
;#define PATTERN9
;#define PATTERN12
;#define PATTERN13
;#define BIN2LED
;#define RANDOM
;#define DEDICATED_BUTTON
;#define DISPLAY_1BIT_B
;#define DISPLAY_2BIT_D
;#define ENABLE_IR
;#include	<P16F688.inc>       ; processor specific variable definitions
; LIST P=PIC16F688
;NUM_TAB     equ d'25'   ;highest pattern table number

;*********************************
; 19 Circle mono
;*********************************
;#define C19
;#define MONO
;#define PATTERN9
;#define PATTERN12
;#define PATTERN14
;#define RANDOM
;#define BIN2LED
;#define DEDICATED_BUTTON
;#define DISPLAY_1BIT_B
;#define DISPLAY_2BIT_E
;#define ENABLE_IR
;#include	<P16F688.inc>       ; processor specific variable definitions
; LIST P=PIC16F688
;NUM_TAB     equ d'25'   ;highest pattern table number


;**********************************************************************
; Macros
;**********************************************************************
; bank select macros
setbank0 macro
    bcf STATUS,RP0  ; select bank 0
    bcf STATUS,RP1
    endm

setbank1 macro
    bsf STATUS,RP0  ; select bank 1
    bcf STATUS,RP1
    endm

mem = 21
var macro name
name equ  mem
mem = mem + 1
   if (mem >= mem2)
      error 'Too much var space used'
   endm

dupvar macro name, name2
name equ name2
   endm

mem2 = 0x7F
var_all_bank macro name
name equ  mem2
mem2 = mem2 - 1
   if (mem >= mem2)
      error 'Too much var space used'
   endm

patternc = 1
start_pattern macro typem, delaym
table#v(patternc)
    if (typem == 1) || (typem == 6)
    dt  typem,delaym,(endpat#v(patternc)-$)/3   ;tbltype1,speed,length
    else
    if (typem == 3) || (typem == 0x0b)
    dt  typem,delaym,(endpat#v(patternc)-$)/2   ;tbltype1,speed,length
    else
    if (typem == 9) || (typem == 0x0e)
    dt  typem,delaym,(endpat#v(patternc)-$)/5   ;tbltype1,speed,length
    else
    if (typem == 0x0a)
    dt  typem,delaym,(endpat#v(patternc)-$)/4   ;tbltype1,speed,length
    else
    if (typem == 0x0d)
    dt  typem,delaym,(endpat#v(patternc)-$)/(9+1)   ;tbltype1,speed,length
    else
    dt  typem,delaym,(endpat#v(patternc)-$-1)
    endif
    endif
    endif
    endif
    endif
   endm

end_pattern macro
endpat#v(patternc)
patternc = patternc + 1
   endm

mult_nop macro nup_count
  local i = nup_count
  while i > 3
    call    Lcontinue   ;4 cycles
i -= 4
  endw
  while i > 1
    goto    $+1         ;2 cycles
i -= 2
  endw
  if i > 0
    nop                 ;1 cycle
  endif
    endm

LedOut macro word,reg_dir,port
    movfw   TMR0
	subwf   word,w
	btfss   STATUS,C    
    bsf     reg_dir, port
   endm

LedOutL macro word,reg_dir,port
    swapf   word,w
    movwf   temp4
    movfw   TMR0
	subwf   temp4,w
	btfss   STATUS,C    
    bsf     reg_dir, port
   endm

LedOutH macro word,reg_dir,port
    nop
    nop
    movfw   TMR0
	subwf   word,w
	btfss   STATUS,C    
    bsf     reg_dir, port
   endm

state_tbl macro num,zero,one,flag
Lstate#v(num)
    if (flag == 0)
       clrf button
       movlw  0x30
       movwf  butcount
    endif 
    if (flag == 1)
       bsf  button,0
    endif
 
    btfsc        IR_in,0
    goto         Lstate#v(num)a

    movlw        zero
    movwf        instate

    goto         Lcontinue
      
Lstate#v(num)a
    movlw        one
    movwf        instate

    goto         Lcontinue    
    endm

state2_tbl macro num, name, offset
Lstate#v(num)
;   save the 1st half of word
    movf         IR_in,w    ; save 1st half
    movwf        IR_lhalf
    incf         instate,f

    goto         Lcontinue
      
Lstate#v(num+1)
;   save the 2nd half of word
;   check for protocal error should get 01 or 10
    movf         IR_lhalf,w
    xorwf        IR_in,w
    btfss        STATUS,Z
    goto         Lstate#v(num+1)a
    clrf         instate    ; error state = zero
 
    goto         Lcontinue

;   set the correct bit in output vars.
Lstate#v(num+1)a
    btfsc        IR_in,0
    bcf          name,offset
    btfss        IR_in,0
    bsf          name,offset

    incf         instate,f    
    goto         Lcontinue
    endm

entry macro a0,a1,a2
    dt      a0,a1,a2
    endm

tbltype1 macro speed,length
  if (length > 2) && (length < d'256')
    dt      0x01,speed,length
  else
    error   'pattern length must be > 2 and < 256'
  endif
    endm

make_mtab macro numtab
  local i = 0
  while i <= numtab
    dt      HIGH table#v(i), LOW table#v(i) 
i += 1
  endw
  endm

make_state_jump_table macro max_state
  local i = 0
  while i <= max_state
    dt      HIGH Lstate#v(i), LOW Lstate#v(i) 
i += 1
  endw
  endm


#ifdef __12F683
PORTA       EQU GPIO
TRISA       EQU TRISIO
NOT_RAPU    EQU NOT_GPPU
#endif


;             ++-------- A7 A6  unimplemented (0)
;             || +------ A4     IR LED output (0)
;             || |+----- A3     detector/button input (1)
;             || ||
;           b'00101111'     ;set LED matrix pins to input (tri-stated)
;               |  ||| 
;               +--+++-- LED matrix on A5 A2 A1 A0 (1)

;**********************************************************************
    ORG     0x000           ; processor reset vector
;**********************************************************************
    goto        main            ; go to beginning of program

;**********************************************************************
    ORG     0x004           ; interrupt vector location
;**********************************************************************
    var_all_bank w_temp          ; variable used for context saving
    var_all_bank status_temp     ; variable used for context saving
    var_all_bank intcon_save     ; variable used for context saving
    var_all_bank pclath_temp

    var nextf                    ; flags for timing loops
;                                  bit 0 is one display cycle (890 usec)
;                                  bit 1 is about 1 minute
    var dcycle                   ; stobe counter [0-3]
    var count1                   ; lower bit counter
    var count2                   ; higher bit counter.

#ifdef __12F683
    movwf       w_temp          ; copy W to TEMP register
    swapf       STATUS,w        ; Swap status to be saved into W
    clrf        STATUS          ; Bank 0
    movwf       status_temp     ; save off contents of PCLATH register
#else
	movwf		w_temp			; save off current W register contents
	movf		STATUS,w		; move status register into W register
	movwf		status_temp		; save off contents of STATUS register
	movf		PCLATH,w		; move pclath register into W register
	movwf		pclath_temp		; save off contents of PCLATH register
#endif

    setbank0
;
;   set tick interupt to 889ms for IR RC5 protocal 1/2 digit.
;   an Interupt every 889us /w 8mhz internal osc
;

#define  TICK_VALUE   D'35'

    movlw       TICK_VALUE
    movwf       TMR0                       
;
;   increment the stobe and duration counters
;

    incf     dcycle,f
#ifdef S19
    movlw    0x05
#else
#ifdef C19
    movlw   0x07
#else
    movlw    0x04
#endif
#endif
    subwf    dcycle,w
    btfsc    STATUS,C
    clrf     dcycle

    bsf      nextf,0

    incfsz      count1,f
    goto        skip1

    incfsz      count2,f
    goto        skip1

    bsf         nextf,1

skip1

    movf        scount,w                    ; F22
    addlw       0                           ; F23
    btfsc       STATUS,Z                    ; F24
    goto        send_nothing                ; F25

    btfss       tx_1,0                      ; F26
    goto        send_zero                   ; F27

;--------------------------------------------------------------------------------------
send_one  ; we are slaming the 36K IR siginal, its like a busy wait!
;--------------------------------------------------------------------------------------
    var repeat

#ifdef S19
    setbank1
    movlw   b'00010010'      ;set A0 & A5 led to outpu
    movwf   TRISA
    setbank0
#define IRBIT 0
#else
#define IRBIT 4
#endif
    bsf         PORTA,IRBIT                     ; A01

    call        get_next_tx_bit             ; 2 + 11 cycles  A04-A16
;    mult_nop d'9' ; A17-A25
    movlw       01h
    call        qdelay           ; 6 + (1 * 3) = 9 ; A17-A25
    nop

    movlw           0x1E                    ; C26  (23)
    movwf           repeat                  ; C27
repeat_loop
    bcf         PORTA,IRBIT                         ; D01

;    mult_nop d'26' ; D02-D27
    movlw       07h
    call        qdelay           ; 6 + (7 * 3) = 27 ; D02-D27

    bsf         PORTA,IRBIT                         ; E01  (27)

;    mult_nop d'23' ; E02-E24
    movlw       06h              ; 6+(6 * 3) = 22 ; E02-E24
    call qdelay

    decfsz      repeat,f                    ; E25      (24)
    goto        repeat_loop                    ; E26/E27

    bcf         PORTA,IRBIT
    goto        exit_tx

;--------------------------------------------------------------------------------------
send_zero  ; we are going to release all the CPU time to the main line for display.
;--------------------------------------------------------------------------------------

    call        get_next_tx_bit             ; 2 + 11 cycles  A04-A16
    goto        drive_main_leds

;--------------------------------------------------------------------------------------
send_nothing ; Drive the main LEDs.
;--------------------------------------------------------------------------------------

    call        read_ir_in
#ifdef DEDICATED_BUTTON
    call        read_button_in
#endif
;   goto        drive_main_leds   

;--------------------------------------------------------------------------------------
drive_main_leds ; Drive the main LEDs.
;--------------------------------------------------------------------------------------

	var fcount
#ifndef S19
#ifndef C19
	var Ar_reg
	var Ag_reg
	var Ab_reg
	var Br_reg
	var Bg_reg
	var Bb_reg
	var Cr_reg
	var Cg_reg
	var Cb_reg
	var Dr_reg
	var Dg_reg
	var Db_reg
#endif
#endif
#ifdef BADGE
    var Center_reg
#endif
#ifdef S19
    var A0_A1_reg
    var A0_A2_reg
    var A0_A4_reg
    var A0_A5_reg
    var A1_A0_reg
    var A1_A2_reg
    var A1_A4_reg
    var A1_A5_reg
    var A2_A0_reg
    var A2_A1_reg
    var A2_A4_reg
    var A2_A5_reg
    var A4_A0_reg
    var A4_A1_reg
    var A4_A2_reg
    var A4_A5_reg
    var A5_A0_reg
    var A5_A1_reg
    var A5_A2_reg
    var A5_A4_reg
#endif
#ifdef C19
    var temp4
    var A0_A1_reg
    var A0_A2_reg
    var A0_C0_reg
    var A0_C1_reg
    var A0_C2_reg
    var A0_C4_reg
    var A1_A2_reg
    var A1_C0_reg
    var A1_C1_reg
    var A1_C2_reg
    var A1_C4_reg
    var A2_C0_reg
    var A2_C1_reg
    var A2_C2_reg
    var A2_C4_reg
    var C0_C1_reg
    var C0_C2_reg
    var C0_C4_reg
    var C1_C2_reg
    var C1_C4_reg
    var C2_C4_reg
#endif
    var_all_bank Ax_dir
#ifdef C19
    var_all_bank Cx_dir
#endif

;
; This is the number of times the display logic should cycle before exiting. It's been hand timed from the
; start of the interupt to the end to be around 800usec. This leaves 90 usec for the main loop.
; The 19 stick has an extra display line strobe cycle.
;
#ifdef S19
    movlw   0x30
#else
#ifdef C19
    movlw   0x18
#else
    movlw   0x3a
#endif
#endif

    movwf   fcount

#ifdef C19
    movlw   b'00101000'     ;set LED matrix pins to input (tri-stated)
    movwf   Ax_dir
    clrf    Cx_dir          ;set LED matrix pins to input (tri-stated)
#else
    movlw   b'00001000'     ;set LED matrix pins to input (tri-stated)
    movwf   Ax_dir
#endif

;    clrf         dcycle ; DDF

    movf         dcycle,w         ; testing for 0
    btfsc        STATUS,Z
    call         display_cycle0

    movlw        0x01             ; testing for 1
    subwf        dcycle,w
    btfsc        STATUS,Z
    call         display_cycle1

    movlw        0x02             ; testing for 2
    subwf        dcycle,w
    btfsc        STATUS,Z
    call         display_cycle2

    movlw        0x03             ; testing for 3
    subwf        dcycle,w
    btfsc        STATUS,Z
    call         display_cycle3

#ifdef S19
    movlw        0x04             ; testing for 4
    subwf        dcycle,w
    btfsc        STATUS,Z
    call         display_cycle4
#endif
#ifdef C19
    movlw        0x04             ; testing for 4
    subwf        dcycle,w
    btfsc        STATUS,Z
    call         display_cycle4

    movlw        0x05             ; testing for 5
    subwf        dcycle,w
    btfsc        STATUS,Z
    call         display_cycle5

    movlw        0x06             ; testing for 6
    subwf        dcycle,w
    btfsc        STATUS,Z
    call         display_cycle6

#endif

;--------------------------------------------------------------------------------------
exit_tx
;--------------------------------------------------------------------------------------

    clrf       PORTA         ;DDF debug hack               ; turn all the LED off

;   clear timer0 interupt
    bcf         INTCON,T0IF

; restore state, return form interupt

exit_int
#ifdef __12F683
    swapf       status_temp,w
    movwf       STATUS
    swapf       w_temp,f
    swapf       w_temp,w
#else
	movf		pclath_temp,w		; retrieve copy of PCLATH register
	movwf		PCLATH			; restore pre-isr PCLATH register contents	
	movf		status_temp,w		; retrieve copy of STATUS register
	movwf		STATUS			; restore pre-isr STATUS register contents
	swapf		w_temp,f
	swapf		w_temp,w		; restore pre-isr W register content
#endif
    retfie                  ; return from interrupt

;--------------------------------------------------------------------------------------
display_cycle0
;--------------------------------------------------------------------------------------

    call    strobe_a0
    decfsz  fcount,f
    goto    display_cycle0


    call    get_state_tbl_hi_address
    call    strobe_a0
    call    get_state_tbl_low_address
    call    strobe_a0
    call    go_state_table
    call    strobe_a0
    call    set_max_state
    call    strobe_a0

    return

;--------------------------------------------------------------------------------------
display_cycle1
;--------------------------------------------------------------------------------------

    call    strobe_a1
    decfsz  fcount,f
    goto    display_cycle1

    call    get_state_tbl_hi_address
    call    strobe_a1
    call    get_state_tbl_low_address
    call    strobe_a1
    call    go_state_table
    call    strobe_a1
    call    set_max_state
    call    strobe_a1

    return

;--------------------------------------------------------------------------------------
display_cycle2
;--------------------------------------------------------------------------------------

    call    strobe_a2
    decfsz  fcount,f
    goto    display_cycle2

    call    get_state_tbl_hi_address
    call    strobe_a2
    call    get_state_tbl_low_address
    call    strobe_a2
    call    go_state_table
    call    strobe_a2
    call    set_max_state
    call    strobe_a2

    return

;--------------------------------------------------------------------------------------
display_cycle3
;--------------------------------------------------------------------------------------

#ifndef C19
    call    strobe_a5
    decfsz  fcount,f
    goto    display_cycle3

    call    get_state_tbl_hi_address
    call    strobe_a5
    call    get_state_tbl_low_address
    call    strobe_a5
    call    go_state_table
    call    strobe_a5
    call    set_max_state
    call    strobe_a5

    return
#else
    call    strobe_c0
    decfsz  fcount,f
    goto    display_cycle3

    call    get_state_tbl_hi_address
    call    strobe_c0
    call    get_state_tbl_low_address
    call    strobe_c0
    call    go_state_table
    call    strobe_c0
    call    set_max_state
    call    strobe_c0

    return
#endif

#ifdef S19
;--------------------------------------------------------------------------------------
display_cycle4
;--------------------------------------------------------------------------------------

    call    strobe_a4
    decfsz  fcount,f
    goto    display_cycle4

    call    get_state_tbl_hi_address
    call    strobe_a4
    call    get_state_tbl_low_address
    call    strobe_a4
    call    go_state_table
    call    strobe_a4
    call    set_max_state
    call    strobe_a4

    return
#endif
#ifdef C19
;--------------------------------------------------------------------------------------
display_cycle4
;--------------------------------------------------------------------------------------

    call    strobe_c1
    decfsz  fcount,f
    goto    display_cycle4

    call    get_state_tbl_hi_address
    call    strobe_c1
    call    get_state_tbl_low_address
    call    strobe_c1
    call    go_state_table
    call    strobe_c1
    call    set_max_state
    call    strobe_c1

    return

;--------------------------------------------------------------------------------------
display_cycle5
;--------------------------------------------------------------------------------------

    call    strobe_c2
    decfsz  fcount,f
    goto    display_cycle5

    call    get_state_tbl_hi_address
    call    strobe_c2
    call    get_state_tbl_low_address
    call    strobe_c2
    call    go_state_table
    call    strobe_c2
    call    set_max_state
    call    strobe_c2

    return

;--------------------------------------------------------------------------------------
display_cycle6
;--------------------------------------------------------------------------------------

    call    strobe_c4
    decfsz  fcount,f
    goto    display_cycle6

    call    get_state_tbl_hi_address
    call    strobe_c4
    call    get_state_tbl_low_address
    call    strobe_c4
    call    go_state_table
    call    strobe_c4
    call    set_max_state
    call    strobe_c4

    return
#endif

;--------------------------------------------------------------------------------------
strobe_a0
;--------------------------------------------------------------------------------------
#ifdef RGB4
#ifdef Common_Cathode
    LedOut  Dr_reg,Ax_dir,1    ;LED Dr     A0-A1
    LedOut  Dg_reg,Ax_dir,2    ;LED Dg     A0-A2
    LedOut  Db_reg,Ax_dir,5    ;LED Db     A0-A5
#else
    LedOut  Ab_reg,Ax_dir,1    ;LED Ab     A0-A1
    LedOut  Bg_reg,Ax_dir,2    ;LED Bg     A0-A2
    LedOut  Cr_reg,Ax_dir,5    ;LED Cr     A0-A5
#endif
#endif
#ifdef BI6
    LedOut  Ab_reg,Ax_dir,1    ;LED Dr     A0-A1  
    LedOut  Cr_reg,Ax_dir,2    ;LED Dg     A0-A2
    LedOut  Db_reg,Ax_dir,5    ;LED Db     A0-A5
#endif
#ifdef S19
    LedOut  A0_A1_reg,Ax_dir,1    ;LED A0-A1  
    LedOut  A0_A2_reg,Ax_dir,2    ;LED A0-A2
    LedOut  A0_A4_reg,Ax_dir,4    ;LED A0-A4
    LedOut  A0_A5_reg,Ax_dir,5    ;LED A0-A5
#endif

#ifdef C19
    LedOutH  A0_A1_reg,Ax_dir,1    ;LED A0-A1  
    LedOutH  A0_A2_reg,Ax_dir,2    ;LED A0-A2
    LedOutH  A0_C0_reg,Cx_dir,0    ;LED A0-C0
    LedOutH  A0_C1_reg,Cx_dir,1    ;LED A0-C1
    LedOutH  A0_C2_reg,Cx_dir,2    ;LED A0-C2
    LedOutH  A0_C4_reg,Cx_dir,4    ;LED A0-C4
#endif

    setbank1
    movf    Ax_dir,w      ;set portA direction
    movwf   TRISA
#ifdef C19
    movf    Cx_dir,w      ;set portA direction
    movwf   TRISC
#endif
    setbank0

    movlw   b'00000001'
    movwf   PORTA
#ifdef C19
    movlw   b'00000000'
    movwf   PORTC
#endif
    return

;--------------------------------------------------------------------------------------
strobe_a1
;--------------------------------------------------------------------------------------
#ifdef RGB4
#ifdef Common_Cathode
    LedOut  Ab_reg,Ax_dir,0    ;LED Ab     A1-A0
    LedOut  Ar_reg,Ax_dir,2    ;LED Ar     A1-A2
    LedOut  Ag_reg,Ax_dir,5    ;LED Ag     A1-A5
#else
    LedOut  Dr_reg,Ax_dir,0    ;LED Dr     A1-A0
    LedOut  Bb_reg,Ax_dir,2    ;LED Bb     A1-A2
    LedOut  Cg_reg,Ax_dir,5    ;LED Cg     A1-A5
#endif
#endif
#ifdef BI6
    LedOut  Bb_reg,Ax_dir,0    ;LED Dr     A1-A0
    LedOut  Ag_reg,Ax_dir,2    ;LED Dg     A1-A2
    LedOut  Ar_reg,Ax_dir,5    ;LED Db     A1-A5
#endif
#ifdef S19
    LedOut  A1_A0_reg,Ax_dir,0    ;LED A1-A0
    LedOut  A1_A2_reg,Ax_dir,2    ;LED A1-A2
    LedOut  A1_A4_reg,Ax_dir,4    ;LED A1-A4
    LedOut  A1_A5_reg,Ax_dir,5    ;LED A1-A5
#endif
#ifdef C19
    LedOutL  A0_A1_reg,Ax_dir,0    ;LED A1-A0  
    LedOutH  A1_A2_reg,Ax_dir,2    ;LED A1-A2
    LedOutH  A1_C0_reg,Cx_dir,0    ;LED A1-C0
    LedOutH  A1_C1_reg,Cx_dir,1    ;LED A1-C1
    LedOutH  A1_C2_reg,Cx_dir,2    ;LED A1-C2
    LedOutH  A1_C4_reg,Cx_dir,4    ;LED A1-C4
#endif

    setbank1
    movf    Ax_dir,w      ;set portA direction
    movwf   TRISA
#ifdef C19
    movf    Cx_dir,w      ;set portA direction
    movwf   TRISC
#endif
    setbank0
    movlw   b'00000010'
    movwf   PORTA
#ifdef C19
    movlw   b'00000000'
    movwf   PORTC
#endif
    return

;--------------------------------------------------------------------------------------
strobe_a2
;--------------------------------------------------------------------------------------
#ifdef RGB4
#ifdef Common_Cathode
    LedOut  Bg_reg,Ax_dir,0    ;LED Bg     A2-A0
    LedOut  Bb_reg,Ax_dir,1    ;LED Bb     A2-A1
    LedOut  Br_reg,Ax_dir,5    ;LED Br     A2-A5
#else
    LedOut  Dg_reg,Ax_dir,0    ;LED Dg     A2-A0
    LedOut  Ar_reg,Ax_dir,1    ;LED Ar     A2-A1
    LedOut  Cb_reg,Ax_dir,5    ;LED Cb     A2-A5
#endif
#endif
#ifdef BI6
    LedOut  Dr_reg,Ax_dir,0    ;LED Dr     A2-A0
    LedOut  Bg_reg,Ax_dir,1    ;LED Dg     A2-A1
    LedOut  Dg_reg,Ax_dir,5    ;LED Db     A2-A5
#endif
#ifdef S19
    LedOut  A2_A0_reg,Ax_dir,0    ;LED A2-A0
    LedOut  A2_A1_reg,Ax_dir,1    ;LED A2-A1
    LedOut  A2_A4_reg,Ax_dir,4    ;LED A2-A4
    LedOut  A2_A5_reg,Ax_dir,5    ;LED A2-A5
#endif
#ifdef C19
    LedOutL  A0_A2_reg,Ax_dir,0    ;LED A2-A0  
    LedOutL  A1_A2_reg,Ax_dir,1    ;LED A2-A1
    LedOutH  A2_C0_reg,Cx_dir,0    ;LED A2-C0
    LedOutH  A2_C1_reg,Cx_dir,1    ;LED A2-C1
    LedOutH  A2_C2_reg,Cx_dir,2    ;LED A2-C2
    LedOutH  A2_C4_reg,Cx_dir,4    ;LED A2-C4
#endif


    setbank1
    movf    Ax_dir,w      ;set portA direction
    movwf   TRISA
#ifdef C19
    movf    Cx_dir,w      ;set portA direction
    movwf   TRISC
#endif
    setbank0

    movlw   b'00000100'
    movwf   PORTA
#ifdef C19
    movlw   b'00000000'
    movwf   PORTC
#endif
    return

;--------------------------------------------------------------------------------------
strobe_c0
;--------------------------------------------------------------------------------------

#ifdef C19
    LedOutL  A0_C0_reg,Ax_dir,0    ;LED C0-A0  
    LedOutL  A1_C0_reg,Ax_dir,1    ;LED C0-A1
    LedOutL  A2_C0_reg,Ax_dir,2    ;LED C0-A4
    LedOutH  C0_C1_reg,Cx_dir,1    ;LED C0-C1
    LedOutH  C0_C2_reg,Cx_dir,2    ;LED C0-C2
    LedOutH  C0_C4_reg,Cx_dir,4    ;LED C0-C4

    setbank1
    movf    Ax_dir,w      ;set portA direction
    movwf   TRISA
    movf    Cx_dir,w      ;set portA direction
    movwf   TRISC
    setbank0

    movlw   b'00000000'
    movwf   PORTA

    movlw   b'00000001'
    movwf   PORTC

    return
#endif
;--------------------------------------------------------------------------------------
strobe_c1
;--------------------------------------------------------------------------------------

#ifdef C19
    LedOutL  A0_C1_reg,Ax_dir,0    ;LED C1-A0  
    LedOutL  A1_C1_reg,Ax_dir,1    ;LED C1-A1
    LedOutL  A2_C1_reg,Ax_dir,2    ;LED C1-A4
    LedOutL  C0_C1_reg,Cx_dir,0    ;LED C1-C0
    LedOutH  C1_C2_reg,Cx_dir,2    ;LED C1-C2
    LedOutH  C1_C4_reg,Cx_dir,4    ;LED C1-C4

    setbank1
    movf    Ax_dir,w      ;set portA direction
    movwf   TRISA
    movf    Cx_dir,w      ;set portA direction
    movwf   TRISC
    setbank0

    movlw   b'00000000'
    movwf   PORTA

    movlw   b'00000010'
    movwf   PORTC

    return
#endif

;--------------------------------------------------------------------------------------
strobe_c2
;--------------------------------------------------------------------------------------

#ifdef C19
    LedOutL  A0_C2_reg,Ax_dir,0    ;LED C2-A0  
    LedOutL  A1_C2_reg,Ax_dir,1    ;LED C2-A1
    LedOutL  A2_C2_reg,Ax_dir,2    ;LED C2-A4
    LedOutL  C0_C2_reg,Cx_dir,0    ;LED C2-C0
    LedOutL  C1_C2_reg,Cx_dir,1    ;LED C2-C1
    LedOutH  C2_C4_reg,Cx_dir,4    ;LED C2-C4

    setbank1
    movf    Ax_dir,w      ;set portA direction
    movwf   TRISA
    movf    Cx_dir,w      ;set portA direction
    movwf   TRISC
    setbank0

    movlw   b'00000000'
    movwf   PORTA

    movlw   b'00000100'
    movwf   PORTC

    return
#endif

;--------------------------------------------------------------------------------------
strobe_c4
;--------------------------------------------------------------------------------------

#ifdef C19
    LedOutL  A0_C4_reg,Ax_dir,0    ;LED C4-A0  
    LedOutL  A1_C4_reg,Ax_dir,1    ;LED C4-A1
    LedOutL  A2_C4_reg,Ax_dir,2    ;LED C4-A4
    LedOutL  C0_C4_reg,Cx_dir,0    ;LED C4-C0
    LedOutL  C1_C4_reg,Cx_dir,1    ;LED C4-C1
    LedOutL  C2_C4_reg,Cx_dir,2    ;LED C4-C2

    setbank1
    movf    Ax_dir,w      ;set portA direction
    movwf   TRISA
    movf    Cx_dir,w      ;set portA direction
    movwf   TRISC
    setbank0

    movlw   b'00000000'
    movwf   PORTA

    movlw   b'00010000'
    movwf   PORTC

    return
#endif

#ifdef S19
;--------------------------------------------------------------------------------------
strobe_a4
;--------------------------------------------------------------------------------------

    LedOut  A4_A0_reg,Ax_dir,0    ;LED     A4-A0
    LedOut  A4_A1_reg,Ax_dir,1    ;LED     A4-A1
    LedOut  A4_A2_reg,Ax_dir,2    ;LED     A4-A2
    LedOut  A4_A5_reg,Ax_dir,5    ;LED     A4-A5

    setbank1
    movf    Ax_dir,w      ;set portA direction
    movwf   TRISA
    setbank0

    movlw   b'00010000'
    movwf   PORTA

    return
#endif

;--------------------------------------------------------------------------------------
strobe_a5
;--------------------------------------------------------------------------------------
#ifdef RGB4
#ifdef Common_Cathode
    LedOut  Cr_reg,Ax_dir,0    ;LED Cr     A5-A0
    LedOut  Cg_reg,Ax_dir,1    ;LED Cg     A5-A1
    LedOut  Cb_reg,Ax_dir,2    ;LED Cb     A5-A2
#else
    LedOut  Db_reg,Ax_dir,0    ;LED Db     A5-A0
    LedOut  Ag_reg,Ax_dir,1    ;LED Ag     A5-A1
    LedOut  Br_reg,Ax_dir,2    ;LED Br     A5-A2
#endif
#endif
#ifdef BI6
    LedOut  Cb_reg,Ax_dir,0    ;LED Dr     A5-A0
    LedOut  Cg_reg,Ax_dir,2    ;LED Db     A5-A2
    LedOut  Br_reg,Ax_dir,1    ;LED Dg     A5-A1
#endif
#ifdef S19
    LedOut  A5_A0_reg,Ax_dir,0    ;LED A5-A0
    LedOut  A5_A1_reg,Ax_dir,1    ;LED A5-A1
    LedOut  A5_A2_reg,Ax_dir,2    ;LED A5-A2
    LedOut  A5_A4_reg,Ax_dir,4    ;LED A5-A4
#endif

    setbank1
    movf    Ax_dir,w      ;set portA direction
    movwf   TRISA
    setbank0

#ifdef BADGE
    var a_out

    movlw   b'00110000'   ; Badge Center LED A4-Ground
    movwf   a_out
    movfw   TMR0
    subwf   Center_reg,w
    btfss   STATUS,C    
    bcf     a_out,4
    movfw   a_out
    movwf   PORTA
#else
    movlw   b'00100000'
    movwf   PORTA
#endif

    return

;**************************************************************************************
;
; State Machine
;
;**************************************************************************************

    var instate
    var max_instate
    var IR_in
    var command
    var address
    var toggle
    var IR_lhalf
    var button
    var tx_1
    var pindex2
    var IR_in_good
    var butcount

;--------------------------------------------------------------------------------------
get_state_tbl_hi_address ; 17 cycles
;--------------------------------------------------------------------------------------
    var tbl2_hi

    bcf          STATUS,0        ; clear carry flag           ; 1
    rlf          instate,w       ; entry = table * 2          ; 2
    movwf        pindex2                                      ; 3
    call         table_lookup2                                ; 14 (9+2)
    movwf        tbl2_hi                                      ; 15
    return                                                    ; 16/17

;--------------------------------------------------------------------------------------
get_state_tbl_low_address  ; 18 cycles
;--------------------------------------------------------------------------------------
    var tbl2_low

    bcf          STATUS,0      ; clear carry flag (just in case)  ; 1
    rlf          instate,w     ; entry = table * 2 + 1            ; 2
    addlw        1                                                ; 3
    movwf        pindex2                                          ; 4
    call         table_lookup2                                    ; 15 (9+2)
    movwf        tbl2_low                                         ; 16
    return                                                        ; 17/18

;**********************************************************************
table_lookup2  ; 9 cycles
;**********************************************************************
    movlw        HIGH state_jump_table                 ; 1
    movwf        PCLATH                                ; 2
    movf         pindex2,w                             ; 3
    addlw        LOW state_jump_table                  ; 4
    btfsc        STATUS,0     ; check carry flag       ; 5
    incf         PCLATH,f                              ; 6
    movwf        PCL                                   ; 7 + 2

;**********************************************************************
go_state_table  ; 18 cycles
;**********************************************************************

    movf         tbl2_hi,w    ; 1
    movwf        PCLATH       ; 2
    movf         tbl2_low,w   ; 3
    movwf        PCL          ; 4

;**********************************************************************
state_jump_table
;**********************************************************************
    make_state_jump_table d'31'

    state_tbl 0, 6, 1, 0
    state_tbl 1, 0, 2, -1
    state_tbl 2, 0, 3, -1
    state_tbl 3, 4, 3, -1
    state_tbl 4, 0, 5, -1
    state_tbl 5, 7, 0, -1

Lstate6
 
     btfsc        IR_in,0
     goto         Lstate6a

     movlw        0
     addwf        butcount,w
     btfsc        STATUS,Z
     goto         Lstate6b

     decfsz       butcount,f
     goto         Lcontinue
     
Lstate6b

     bsf  button,0
     goto         Lcontinue
     
Lstate6a
     clrf        instate
     goto         Lcontinue       

    state2_tbl 7, toggle, 0
    state2_tbl 9, address, 4    
    state2_tbl d'11', address, 3    
    state2_tbl d'13', address, 2    
    state2_tbl d'15', address, 1    
    state2_tbl d'17', address, 0    
    state2_tbl d'19', command, 5    
    state2_tbl d'21', command, 4    
    state2_tbl d'23', command, 3    
    state2_tbl d'25', command, 2    
    state2_tbl d'27', command, 1    
    state2_tbl d'29', command, 0    

Lstate31
    clrf        instate
    bsf         IR_in_good,0    

Lcontinue
    return

;--------------------------------------------------------------------------------------
read_button_in   ; 5 cycles
;--------------------------------------------------------------------------------------
; Portability : hardcoded button port
;

    bcf         button,0         ; 1
#ifndef SIM_DEBUG
    btfss       PORTA,5          ; 2
    bsf         button,0         ; 3
#endif
    return                        

;--------------------------------------------------------------------------------------
read_ir_in   ; 5 cycles
;--------------------------------------------------------------------------------------

    bcf         IR_in,0         ; 1
#ifndef SIM_DEBUG
    btfsc       PORTA,3         ; 2
#endif
    bsf         IR_in,0         ; 3

;    movf        tx_1,w   ; loopback for testing HACK!!        ;1
;    xorlw       0x01       ; loopback for testing HACK!!      ;2
;    movwf       IR_in      ; loopback for testing HACK!!      ;3
    return                                                     ; 4/5

;--------------------------------------------------------------------------------------
set_max_state   ; 5-7 cycles
;--------------------------------------------------------------------------------------
    movf         max_instate,w  
    subwf        instate,w       
    btfss        STATUS,C        
    goto         smi_l1          
    movf         instate,w       
    movwf        max_instate     
smi_l1
    return                       

;--------------------------------------------------------------------------------------
get_next_tx_bit   ; 11 cycles
;--------------------------------------------------------------------------------------

    bcf         tx_1,0                                 ;1
    decf        scount,f                               ;2
    bcf         STATUS, C   ; clear carry bit          ;3
    rrf         out3,f                                 ;4
    rrf         out2,f                                 ;5
    rrf         out1,f                                 ;6
    rrf         out0,f                                 ;7
    btfsc       STATUS, C                              ;8
    bsf         tx_1,0                                 ;9
 
;    movf        tx_1,w   ; loopback for testing HACK!!
;    xorlw       0x01       ; loopback for testing HACK!!
;    movwf       tx_1      ; loopback for testing HACK!!
;    mult_nop d'6'         ; for debuging
  
    return                                             ;10/11

;**********************************************************************
qdelay
;**********************************************************************
    var qcount

    movwf       qcount
delay_loop2
    decfsz      qcount,1
    goto        delay_loop2
    return
;**********************************************************************
rf_command_out
;**********************************************************************

    var out_address
    var out_command
    var out_toggle
    var out_pattern
    var out0
    var out1
    var out2
    var out3
    var scount

    clrf        out1
    clrf        out2
    clrf        out3

;   start flag
    movlw       B'10100000'
    movwf       out0


;   toggle bit
    comf        out_toggle,f                ; toggle the toggle flag
    btfss       out_toggle,0
    bsf         out1,0
    btfsc       out_toggle,0
    bsf         out1,1

;   address bits
    btfss       out_address,4
    bsf         out1,2
    btfsc       out_address,4
    bsf         out1,3

    btfss       out_address,3
    bsf         out1,4
    btfsc       out_address,3
    bsf         out1,5

    btfss       out_address,2
    bsf         out1,6
    btfsc       out_address,2
    bsf         out1,7

    btfss       out_address,1
    bsf         out2,0
    btfsc       out_address,1
    bsf         out2,1

    btfss       out_address,0
    bsf         out2,2
    btfsc       out_address,0
    bsf         out2,3

;   command bits
    btfss       out_command,5
    bsf         out2,4
    btfsc       out_command,5
    bsf         out2,5

    btfss       out_command,4
    bsf         out2,6
    btfsc       out_command,4
    bsf         out2,7

    btfss       out_command,3
    bsf         out3,0
    btfsc       out_command,3
    bsf         out3,1

    btfss       out_command,2
    bsf         out3,2
    btfsc       out_command,2
    bsf         out3,3

    btfss       out_command,1
    bsf         out3,4
    btfsc       out_command,1
    bsf         out3,5

    btfss       out_command,0
    bsf         out3,6
    btfsc       out_command,0
    bsf         out3,7

    movlw       0x21
    movwf       scount

    return

#ifdef BIN2LED
;**********************************************************************
bin2led
;**********************************************************************
    var b2l_out_hi
    var b2l_out_low
    var b2l_lcount
    var b2l_in_red
    var b2l_in_green

    clrf        b2l_out_hi
    clrf        b2l_out_low
    movlw       0x08
    movwf        b2l_lcount
b2l_loop
    bcf         STATUS, C
    rrf         b2l_in_green,f
    rlf         b2l_out_low,f
    rlf         b2l_out_hi,f
    rrf         b2l_in_red,f
    rlf         b2l_out_low,f
    rlf         b2l_out_hi,f

    decfsz      b2l_lcount,f
    goto        b2l_loop
    return
#endif

#ifdef FLIPBYTE
;**********************************************************************
flipbyte
;**********************************************************************
     var flip_in
     var flip_out
     var flip_lcount

     movwf       flip_in
     clrf        flip_out
     movlw       0x08
     movwf       flip_lcount
fbyte_loop
     bcf         STATUS, C
     rrf         flip_in,f
     rlf         flip_out,f
 
     decfsz      flip_lcount,f
     goto        fbyte_loop
 
     movfw       flip_out
     return
#endif
                 
;**********************************************************************
delay
;**********************************************************************

    var         delay_count

;   movlw       0ffh
    movwf       delay_count
delay_loop
    nop
    decfsz      delay_count,1
    goto        delay_loop
    return

;**********************************************************************
next_pattern
;**********************************************************************
    incf         pattern,f
    movf         pattern,w
    sublw        NUM_TAB+1  ; max pattern?
    btfsc        STATUS,2   ; z bit check
    clrf         pattern    ; reset to zero
    movfw        pattern
    movwf        out_pattern
    return

;**********************************************************************
past_pattern
;**********************************************************************
    decf         pattern,f
    movf         pattern,w
    addlw        1  ; max pattern?
    btfss        STATUS,2   ; z bit check
    goto         past_exit
    movlw        NUM_TAB
    movwf        pattern
    movwf        out_pattern
past_exit
    return

;**********************************************************************
set_pattern         ;set pattern from IR
;**********************************************************************
; extra logic because all the different blinkes talk to each other, but
; do not have the same number of patterns. So if blinkie "A" sents a
; pattern 22 to blinkie "B" which only has 10 patterns, Blinkie "B"
; starts to show pattern 2. (22 % 10 a mod function.) But to make
; things fair in blinkie wars, it will transmit pattern 22 to other
; blinkies.
;**********************************************************************

    movfw        command
    movwf        pattern
    movwf        out_pattern
set_loop
    addlw        0xff-NUM_TAB
    btfss        STATUS, C
    goto         set_exit

    movlw        NUM_TAB
    subwf        pattern,f
    movfw        pattern
    goto         set_loop

set_exit
    return

;**********************************************************************
strobe_delay
;**********************************************************************

    var          strobe_count

    movwf        strobe_count
strobe_delay1
    bcf          nextf,0

strobe_delay2
    btfss        nextf,0
    goto         strobe_delay2

    decfsz       strobe_count,f
    goto         strobe_delay1

    return

;**********************************************************************
display_pattern_id
;**********************************************************************
    incf         pattern,w      ; W = pattern + 1
    movwf        in0

#ifdef S19
    call         flipbyte
    movwf        in0
#endif
#ifdef BI6
#ifdef MONO
    call         flipbyte
    movwf        in0
#else
    movwf        b2l_in_green
    clrf         b2l_in_red
    call         bin2led
    movf         b2l_out_hi,w
    movwf        in0
    movf         b2l_out_low,w
    movwf        in1
#endif
#endif

#ifdef C19
;   outer ring hars the pattern number
    movwf        b2l_in_red
    clrf         b2l_in_green
    call         bin2led
    movf         b2l_out_hi,w
    movwf        in0
    movf         b2l_out_low,w
    movwf        in1

;   center LED turned on
    clrf         in2          
    clrf         in3
    movlw        b'00001100'  
    movwf        in4

;   middle ring on if demo mode
    btfss        demo_mode,0
    goto         skip4

    comf         in3
    movlw        b'11111100'  
    movwf        in4
skip4

#endif



#ifdef S19
    clrf        in1
    clrf        in2

    movlw        b'11100000'
    btfsc        demo_mode,0
    movwf        in2    
#else
#ifdef BI6
#ifdef MONO
    btfsc        demo_mode,0
    bsf          in0,2  
#else  ; bicolor
    btfsc        demo_mode,0
    bsf          in1,4  
#endif ; end Mono/bicolor
#endif ; end BI
#endif ; end S19/BI6

#ifdef RGB4
    btfsc        demo_mode,0
    bsf          in1,7  
#endif

    movlw        0xFF
    call         display_1bit

    clrf         in0
    clrf         in1
    clrf         in2
    movlw        0x01
    call         display_1bit
    return

;**********************************************************************
setup_pattern_table
;**********************************************************************
    var tbl_hi
    var tbl_low
    var setup_pattern_temp
    var temp_high

stop2
    movf         pattern,w
    btfss        STATUS,Z
    goto         slabel1
;
;   if patten is zero, check eeprom and verify 1st entry is not a 0x00
;   if it is switch to next pattern.

    clrw
    call         read_eeprom
    movwf        setup_pattern_temp

    clrf         demo_mode
    btfsc        setup_pattern_temp,7
    bsf          demo_mode,0

    movfw        setup_pattern_temp
    btfss        STATUS,Z
    goto         sreturn
    
    call         next_pattern
    goto         stop2

slabel1
;
;   Set the pattern (table)
;
    movlw        HIGH MasterTable
    movwf        tbl_hi
    movlw        LOW MasterTable
    movwf        tbl_low

;   get the high address for the pattern table
    bcf          STATUS,0      ; clear carry flag
    rlf          pattern,w     ; entry = table * 2
    movwf        pindex
    bcf          INTCON, GIE      ; disable INTs
    call         table_lookup
    bsf          INTCON, GIE      ; enable INTs
    movwf        temp_high          ; can't put it in tbl_high yet

;   get the low address for the pattern table
    bsf          STATUS,0      ; set carry
    rlf          pattern,w     ; entry = table * 2 + 1
    movwf        pindex
    bcf          INTCON, GIE      ; disable INTs
    call         table_lookup
    bsf          INTCON, GIE      ; enable INTs
    movwf        tbl_low

    movf         temp_high,w
    movwf        tbl_hi

sreturn
    return

;**********************************************************************
get_next_pattern_entry
;**********************************************************************
    var          pclath_save
    var          temp2

    movf         pattern,w
    btfss        STATUS,Z
    goto         glabel1

    movf         pindex,w
    call         read_eeprom
    
    goto         greturn
glabel1
    bcf          INTCON, GIE      ; disable INTs
    movfw        PCLATH
    movwf        pclath_save
    movf         pindex,w
;    bcf          INTCON, GIE      ; disable INTs
    call         table_lookup
;    bsf          INTCON, GIE      ; enable INTs
    movwf        temp2
    movfw        pclath_save
    movwf        PCLATH
    movfw        temp2
    bsf          INTCON, GIE      ; enable INTs

greturn
    incf         pindex,f
    return


;**********************************************************************
write_eeprom
;   expects EEPROM address and data in pindex and input
;   makes sure previous write (if any) has completed before proceeding
;**********************************************************************
    setbank1

    btfsc   EECON1,WR       ;wait for WR to clear
    goto    $-1

    bcf          INTCON, GIE      ; disable INTs
    bsf     EECON1,WREN     ;enable writes
    movf    pindex,w        ;set address
    movwf   EEADR
    movf    input,w         ;set data
    movwf   EEDAT
    movlw   0x55            ;EECON2 = 0x55  ;unlock sequence
    movwf   EECON2
    movlw   0xAA            ;EECON2 = 0xAA  ;unlock sequence
    movwf   EECON2
    bsf     EECON1,WR       ;initiate a write cycle
    bsf          INTCON, GIE      ; enable INT

    setbank0
    return


;**********************************************************************
read_eeprom
;   expects EEPROM address in W
;   returns EEPROM data in W
;   makes sure previous write (if any) has completed before proceeding
;**********************************************************************
    bcf     INTCON, GIE      ; disable INTs
    setbank1

    btfsc   EECON1,WR       ;wait for WR to clear
    goto    $-1

    bcf     EECON1,WREN     ;disable writes
    movwf   EEADR           ;EEADR = W
    bcf     EECON1,7        ;clear EEPGD
    bsf     EECON1,RD       ;initiate a read cycle
    movf    EEDAT,w         ;W = EEDAT

    setbank0
    bsf          INTCON, GIE      ; enable INT
    return

;**********************************************************************
toggle_demo
;**********************************************************************
    var          toggle_demo_temp

    clrw
    call         read_eeprom
    movwf        toggle_demo_temp

    btfss        toggle_demo_temp,7          ;
    goto         tdemo_on

;   toggle off
    bcf          toggle_demo_temp,7
    clrf         demo_mode
    goto         tdemo_cont

tdemo_on
    bsf          toggle_demo_temp,7
    bsf          demo_mode,0

tdemo_cont
    clrf         pindex
    movfw        toggle_demo_temp
    movwf        input
    call         write_eeprom

    call         display_pattern_id
    call         display_pattern_id
    
    return

;**********************************************************************
pattern_driver
;**********************************************************************

    var pattern
    var tbltype
    var in0
    var in1
    var in2
#ifdef C19
    var in3
    var in4
    var in5
    var in6
    var in7
    var in8
    var in9
#endif
#ifdef BADGE
    var in3
#endif
    var speed
    var pspeed
    var demo_mode
    var psize

    ; need to be able to access from page1 & page2 for eeprom read/write
    var_all_bank pindex          ; pattern index
    var_all_bank input

ptop


    call         setup_pattern_table

    clrf         pindex

;   load the table type  (Currently only 1 type)
    call         get_next_pattern_entry
    movwf        tbltype
    bcf          tbltype,7     ; using top bit for demo mode.

;   load the speed (someday this will be a table type 1 only thing.)
    call         get_next_pattern_entry
    movwf        pspeed
    incf         pspeed,f          ; adjust so 0 is fastest, not treated like speed 256

; load the table size
    call         get_next_pattern_entry ;4rgb
    movwf        psize                  ;4rgb

ploop0
;
;   Check for IR command in
;
    btfss        IR_in_good,0
    goto         button_check

blinkie_check
    movlw        0x07              ; blinkines use address 0x07 (Experimental)
    subwf        address,w
    btfss        STATUS,Z
    goto         remote_check    

    call         set_pattern
    clrf         IR_in_good
    goto         ptop

remote_check
    movf         address,f         ; remote giving "0" for address (TV)?
    btfss        STATUS,Z
    goto         button_check

    movlw        0x20              ; remote curser right (pattern ++)
    subwf        command,w
    btfsc        STATUS,Z
    call         next_pattern

    movlw        0x21              ; remote curser left (pattern --)
    subwf        command,w
    btfsc        STATUS,Z
    call         past_pattern

    movlw        0x00              ; remote "0" key  (pattern = 0)
    subwf        command,w
    btfsc        STATUS,Z
    clrf         pattern

    movlw        0x0c              ; remote on/off key (togle demo mode!)
    subwf        command,w
    btfsc        STATUS,Z
    call         toggle_demo

    clrf         IR_in_good
    goto         ptop

button_check
; ploop1

    btfss        button,0    ; if putton pressed show pattern id
    goto         ploop2

    call         display_pattern_id
    call         display_pattern_id

    btfss        button,0    ; if putton still pressed inc pattern
    goto         ploop2

ploop1a
    call         next_pattern
    call         display_pattern_id
    call         display_pattern_id

    btfsc        button,0
    goto         ploop1a
    goto         ptop
    
ploop2

#ifdef PATTERN1
    movlw        0x01              ; pattern1
    subwf        tbltype,w
    btfsc        STATUS,Z
    call         table_type_1
#endif

#ifdef PATTERN2
    movlw        0x02              ; pattern2
    subwf        tbltype,w
    btfsc        STATUS,Z
    call         table_type_2
#endif

#ifdef PATTERN3
    movlw        0x03              ; pattern3
    subwf        tbltype,w
    btfsc        STATUS,Z
    call         table_type_3
#endif

#ifdef PATTERN4
    movlw        0x04              ; pattern4
    subwf        tbltype,w
    btfsc        STATUS,Z
    call         table_type_4
#endif

#ifdef PATTERN5
    movlw        0x05              ; pattern5
    subwf        tbltype,w
    btfsc        STATUS,Z
    call         table_type_5
#endif

#ifdef PATTERN6
    movlw        0x06              ; pattern6
    subwf        tbltype,w
    btfsc        STATUS,Z
    call         table_type_6
#endif

#ifdef PATTERN7
    movlw        0x07              ; pattern7
    subwf        tbltype,w
    btfsc        STATUS,Z
    call         table_type_7
#endif

#ifdef PATTERN8
    movlw        0x08              ; pattern8
    subwf        tbltype,w
    btfsc        STATUS,Z
    call         table_type_8
#endif

#ifdef PATTERN9
    movlw        0x09              ; pattern9
    subwf        tbltype,w
    btfsc        STATUS,Z
    call         table_type_9
#endif

#ifdef PATTERN10
    movlw        0x0A              ; pattern10
    subwf        tbltype,w
    btfsc        STATUS,Z
    call         table_type_10
#endif

#ifdef PATTERN11
    movlw        0x0B              ; pattern11
    subwf        tbltype,w
    btfsc        STATUS,Z
    call         table_type_11
#endif

#ifdef PATTERN12
    movlw        0x0C              ; pattern12
    subwf        tbltype,w
    btfsc        STATUS,Z
    call         table_type_12
#endif

#ifdef PATTERN13
    movlw        0x0D              ; pattern13
    subwf        tbltype,w
    btfsc        STATUS,Z
    call         table_type_13
#endif

#ifdef PATTERN14
    movlw        0x0E              ; pattern14
    subwf        tbltype,w
    btfsc        STATUS,Z
    call         table_type_14
#endif


;   make sure we are not sending a IR signel
    movf        scount,w                    ; F22
    addlw       0                           ; F23
    btfss       STATUS,Z                    ; F24
    goto        ploop3

;   count down till net IR signel
    btfss       nextf,1
    goto        ploop3

    bcf         nextf,1
    btfss       demo_mode,0
    goto        ploop2a

    call        next_pattern
    goto        ptop
   
ploop2a
;   send an IR signel
#ifdef ENABLE_IR
    movlw       0x07                        ; address 0x07 "Experimental"
    movwf       out_address
    movfw       out_pattern
    movwf       out_command                 ; copy out_pettern

    call        rf_command_out 
#endif

ploop3
    decfsz  psize,f     ;check for end of pattern (4rgb)
    goto    ploop0

    goto        ptop

#ifdef PATTERN1
;**********************************************************************
table_type_1
;**********************************************************************
; 76543210 <-- bits
; AABBCCDD <-- LEDs
; 01010101 <-- stays on for 1 unit  - b'01'
; 10101010 <-- stays on for 2 units - b'10'
; 11111111 <-- stays on for 3 units - b'11'

; in0 red
; in1 green
; in2 blu

    call         get_next_pattern_entry
    movwf        in0
  
    call         get_next_pattern_entry
    movwf        in1

    call         get_next_pattern_entry     ;4rgb
    movwf        in2                        ;4rgb

    movf         pspeed,w
    movwf        speed
    call         display_2bit

    return
#endif

#ifdef PATTERN2
;**********************************************************************
table_type_2
;**********************************************************************

    var          delay1
    var          fad
    var          color
    var          fad2

    incf         delay1,f

    movf         delay1,w         ; testing for 0
    btfss        STATUS,Z
    goto         cf_loop2

    movlw        TICK_VALUE     ; we are using timer0 for the counts, 0 through tick value is LED off.
    movwf        delay1 
   
;
;   select a pattern
;
    comf         fad,f
    movf         fad,w         ; testing for 0
    incf         color,f

cf_loop2
    movf        delay1,w         ; fading up
    btfsc       fad,0
	comf        delay1,w         ; dafinf down
    movwf       fad2

    movlw        0x03             ; greater then 3?
    subwf        color,w
    btfsc        STATUS,C
    clrf         color        


    movlw        0x00             ; testing for 0
    subwf        color,w
    btfss        STATUS,Z
    goto         next1

    movfw       fad2
    movwf		Ar_reg
 	movwf		Br_reg
	movwf		Cr_reg
	movwf		Dr_reg

next1
    movlw        0x01             ; testing for 1
    subwf        color,w
    btfss        STATUS,Z
    goto         next2

    movfw       fad2
    movwf		Ag_reg
 	movwf		Bg_reg
	movwf		Cg_reg
	movwf		Dg_reg

next2
    movlw        0x02             ; testing for 2
    subwf        color,w
    btfss        STATUS,Z
    goto         next3

    movfw       fad2
    movwf		Ab_reg
 	movwf		Bb_reg
	movwf		Cb_reg
	movwf		Db_reg

next3
    movfw       pspeed
    call        strobe_delay

    return
#endif


#ifdef PATTERN3
;**********************************************************************
table_type_3
;**********************************************************************
;
;  2 bytes
;
;  RRRRGGGG BBBBCDDD
;
;  RRRR = bit of red LEDs to turn on
;  GGGG = bit of red LEDs to turn on
;  BBBB = bit of red LEDs to turn on
;  CDDD = a repeat counter.
;
;  For badge blinkies
;  C is 13th LED
;  DDD = is repeat count

    var p2count

    call         get_next_pattern_entry
    movwf        in0
  
    call         get_next_pattern_entry
    movwf        in1

#ifdef BADGE
    movlw        b'00000111'
#else
    movlw        b'00001111'
#endif
    andwf        in1,w
    movwf        p2count
    incf         p2count,f
    rlf          p2count,f
    rlf          p2count,f

p2loop
    movfw        pspeed
    call         display_1bit

    decfsz       p2count,f
    goto         p2loop

    return
#endif


#ifdef PATTERN4
;**********************************************************************
table_type_4
;**********************************************************************

    ;use          delay1
    ;use          fad
    ;use          color


    incf         delay1,f

    movf         delay1,w         ; testing for 0
    btfss        STATUS,Z
    goto         cf_loop2a

    movlw        TICK_VALUE     ; we are using timer0 for the counts, 0 through tick value is LED off.
    movwf        delay1 
   
;
;   select a pattern
;
    comf         fad,f
    movf         fad,w         ; testing for 0
    btfss        fad,0
    incf         color,f

cf_loop2a
    movf        delay1,w         ; fading up
    btfsc       fad,0
	comf        delay1,w         ; dafinf down

	movwf		Ar_reg
	movwf		Ag_reg
	movwf		Ab_reg
 	movwf		Br_reg
	movwf		Bg_reg
	movwf		Bb_reg
	movwf		Cr_reg
	movwf		Cg_reg
	movwf		Cb_reg
	movwf		Dr_reg
	movwf		Dg_reg
	movwf	 	Db_reg

    btfsc       color,0
	clrf		Ar_reg
    btfsc       color,1
	clrf		Ag_reg
    btfsc       color,2
 	clrf		Ab_reg
    btfsc       color,0
 	clrf		Br_reg
    btfsc       color,1
	clrf		Bg_reg
    btfsc       color,2
	clrf		Bb_reg
    btfsc       color,0
	clrf		Cr_reg
    btfsc       color,1
	clrf		Cg_reg
    btfsc       color,2
	clrf		Cb_reg
    btfsc       color,0
	clrf		Dr_reg
    btfsc       color,1
	clrf		Dg_reg
    btfsc       color,2
	clrf	 	Db_reg

    btfsc       color,3
    clrf        Ar_reg
    btfsc       color,3
    clrf        Ag_reg
    btfsc       color,3
    clrf        Ab_reg

    btfsc       color,4
    clrf        Br_reg
    btfsc       color,4
    clrf        Bg_reg
    btfsc       color,4
    clrf        Bb_reg  

    btfsc       color,5
    clrf        Cr_reg
    btfsc       color,5
    clrf        Cg_reg
    btfsc       color,5
    clrf        Cb_reg  

    btfsc       color,6
    clrf        Dr_reg
    btfsc       color,6
    clrf        Dg_reg
    btfsc       color,6
    clrf        Db_reg  

    movlw       0x20
    call        strobe_delay

    return
#endif

#ifdef PATTERN5
;**********************************************************************
table_type_5
;**********************************************************************
;
;  1 bytes
;
;  ABCDEFX = 7 bits for LEDs.
;

    var p2count

    call         get_next_pattern_entry
    movwf        in0

    movlw        0x04       ; call display 4 times, speed thing
    movwf        p2count

p2loop
    movfw        pspeed
    call         display_1bit

    decfsz       p2count,f
    goto         p2loop

    return
#endif

#ifdef PATTERN6
;**********************************************************************
table_type_6
;**********************************************************************
;
;  3 bytes
;
;  AAAAAAAA AAAAAAAA AAADDDDD
;
;  A = 19 bits of LED
;  DDDDD = a repeat counter.

    var p2count

    call         get_next_pattern_entry
    movwf        in0
  
    call         get_next_pattern_entry
    movwf        in1

    call         get_next_pattern_entry
    movwf        in2

    movlw        b'00011111'
    andwf        in2,w
    movwf        p2count
    incf         p2count,f
    rlf          p2count,f
    rlf          p2count,f

p2loop
    movfw        pspeed
    call         display_1bit

    decfsz       p2count,f
    goto         p2loop

    return
#endif

#define BRIGHT1 0x40
#define BRIGHT2 0xA0

#ifdef PATTERN7
;**********************************************************************
table_type_7
;**********************************************************************
;
;  1 bytes
;
;  ABBCCCCC
;
;  A = shire Right/Left
;  BB = two bit intensity to shift on
;  CCCCC = Number of shifts to loop
;
;  if CCCCC = 0x11111, specical case: turn all LEDs off.
;

    var t7count

    call         get_next_pattern_entry
    movwf        in0

    movlw        b'00011111'
    andwf        in0,w
    movwf        t7count

    movlw        b'00011111'  ; if shiftcount is 31, then clear all LEDs
    subwf        t7count,w
    btfss        STATUS,Z
    goto         t7_loop
    
    clrf         in0           ; quick way to clear all the LEDS.
    clrf         in1
    clrf         in2
    call         display_1bit
    goto         t7_return


t7_loop
    btfsc        in0,7
    goto         t7_set19
;
;   set LED 1
	movfw		 A1_A4_reg        ; 18 -> 19
	movwf		 A4_A1_reg

	movfw		 A2_A1_reg        ; 17 -> 18
	movwf		 A1_A4_reg

	movfw		 A1_A2_reg        ; 16 -> 17
	movwf		 A2_A1_reg

	movfw	 	 A2_A4_reg        ; 15 -> 16
	movwf		 A1_A2_reg

	movfw		 A4_A2_reg        ; 14 -> 15
	movwf	 	 A2_A4_reg

	movfw		 A0_A1_reg        ; 13 -> 14
	movwf		 A4_A2_reg 

	movfw	 	 A1_A0_reg        ; 12 -> 13
	movwf		 A0_A1_reg

	movfw		 A0_A4_reg        ; 11 -> 12
	movwf	 	 A1_A0_reg

	movfw		 A4_A0_reg        ; 10 -> 11
	movwf		 A0_A4_reg

	movfw	 	 A0_A2_reg        ; 09 -> 10
	movwf		 A4_A0_reg 

    movfw		 A2_A0_reg        ; 08 -> 09
	movwf	 	 A0_A2_reg

	movfw		 A5_A1_reg        ; 07 -> 08
    movwf		 A2_A0_reg

	movfw	 	 A1_A5_reg        ; 06 -> 07
	movwf		 A5_A1_reg 

	movfw		 A5_A4_reg        ; 05 -> 06
	movwf	 	 A1_A5_reg

	movfw		 A4_A5_reg        ; 04 -> 05
	movwf		 A5_A4_reg

	movfw		 A5_A2_reg        ; 03 -> 04
	movwf		 A4_A5_reg 

	movfw		 A2_A5_reg        ; 02 -> 03
	movwf		 A5_A2_reg

	movfw		 A5_A0_reg        ; 01 -> 02
	movwf		 A2_A5_reg

	clrf		 A5_A0_reg
    movlw        BRIGHT1
    btfsc        in0,5
    addwf        A5_A0_reg,f
    movlw        BRIGHT2
    btfsc        in0,6
    addwf        A5_A0_reg,f
    goto         t7_cont
;
;   set LED 19
t7_set19
	movfw		 A2_A5_reg        ; 02 -> 01
	movwf		 A5_A0_reg

	movfw		 A5_A2_reg        ; 03 -> 02
	movwf		 A2_A5_reg

	movfw		 A4_A5_reg        ; 04 -> 03
    movwf		 A5_A2_reg

	movfw		 A5_A4_reg        ; 05 -> 04
	movwf		 A4_A5_reg

	movfw	 	 A1_A5_reg        ; 06 -> 05
	movwf		 A5_A4_reg 

	movfw		 A5_A1_reg        ; 07 -> 06
	movwf	 	 A1_A5_reg

    movfw		 A2_A0_reg        ; 08 -> 07
	movwf		 A5_A1_reg 

	movfw	 	 A0_A2_reg        ; 09 -> 08
    movwf		 A2_A0_reg

	movfw		 A4_A0_reg        ; 10 -> 09
	movwf	 	 A0_A2_reg

	movfw		 A0_A4_reg        ; 11 -> 10
	movwf		 A4_A0_reg

	movfw	 	 A1_A0_reg        ; 12 -> 11
	movwf		 A0_A4_reg

	movfw		 A0_A1_reg        ; 13 -> 12
	movwf	 	 A1_A0_reg

	movfw		 A4_A2_reg        ; 14 -> 13
	movwf		 A0_A1_reg

	movfw	 	 A2_A4_reg        ; 15 -> 14
	movwf		 A4_A2_reg

	movfw		 A1_A2_reg        ; 16 -> 15
	movwf	 	 A2_A4_reg

	movfw		 A2_A1_reg        ; 17 -> 16
	movwf		 A1_A2_reg

	movfw		 A1_A4_reg        ; 18 -> 17
	movwf		 A2_A1_reg

	movfw		 A4_A1_reg        ; 19 -> 18
	movwf		 A1_A4_reg

	clrf		 A4_A1_reg
    movlw        BRIGHT1
    btfsc        in0,5
    addwf        A4_A1_reg,f
    movlw        BRIGHT2
    btfsc        in0,6
    addwf        A4_A1_reg,f

t7_cont

    movf         pspeed,w
    call         strobe_delay
;
;   This is a quick hack, because without this button presses are not seen for minutes
;   This early exit might impact the pattern getting displayed.
;
    btfsc        button,0    ; if putton pressed show pattern id
    goto         t7_return

    btfsc        IR_in_good,0
    goto         t7_return

    decfsz       t7count,f
    goto         t7_loop

t7_return
    return
#endif


#ifdef PATTERN8
;**********************************************************************
table_type_8 ; - 19 LED fader
;**********************************************************************

    var          delay1
    var          fad
    var          color


    incf         delay1,f

    movf         delay1,w         ; testing for 0
    btfss        STATUS,Z
    goto         cf8_loop2a

    movlw        TICK_VALUE     ; we are using timer0 for the counts, 0 through tick value is LED off.
    movwf        delay1 
   
;
;   select a pattern
;
    comf         fad,f
    movf         fad,w         ; testing for 0
    btfss        fad,0
    incf         color,f

cf8_loop2a
    movf        delay1,w         ; fading up
    btfsc       fad,0
	comf        delay1,w         ; fading down

	movwf		 A5_A0_reg        ; 01
	movwf		 A2_A5_reg        ; 02
	movwf		 A5_A2_reg        ; 03
	movwf		 A4_A5_reg        ; 04
	movwf		 A5_A4_reg        ; 05
	movwf	 	 A1_A5_reg        ; 06
	movwf		 A5_A1_reg        ; 07
    movwf		 A2_A0_reg        ; 08
	movwf	 	 A0_A2_reg        ; 09
	movwf		 A4_A0_reg        ; 10
	movwf		 A0_A4_reg        ; 11
	movwf	 	 A1_A0_reg        ; 12
	movwf		 A0_A1_reg        ; 13
	movwf		 A4_A2_reg        ; 14
	movwf	 	 A2_A4_reg        ; 15 
	movwf		 A1_A2_reg        ; 16 
	movwf		 A2_A1_reg        ; 17 
	movwf		 A1_A4_reg        ; 18
	movwf		 A4_A1_reg        ; 19 

    movlw       0x03
    call        strobe_delay

    return
#endif

#ifdef PATTERN9
;**********************************************************************
table_type_9
;**********************************************************************
;
;  5 bytes
;  00000000 00000000 00111111 11111111 111111XX
;  11223344 55667788 99001122 33445566 778899XX
;  RGRGRGRG RGRGRGRG RGRGRGRG RGRGRGRG RGRGRGXX
;
;  XX = a repeat counter.

    var p2count

    call         get_next_pattern_entry
    movwf        in0
  
    call         get_next_pattern_entry
    movwf        in1

    call         get_next_pattern_entry
    movwf        in2

    call         get_next_pattern_entry
    movwf        in3

    call         get_next_pattern_entry
    movwf        in4

    movlw        b'00000011'
    andwf        in4,w
    movwf        p2count
    incf         p2count,f
    rlf          p2count,f
    rlf          p2count,f

p2loop
    movfw        pspeed
    call         display_1bit

    decfsz       p2count,f
    goto         p2loop

    return
#endif

#ifdef PATTERN10
;**********************************************************************
table_type_10
;**********************************************************************
; 76543210 <-- bits
; AABBCCDD <-- LEDs
; 01010101 <-- stays on for 1 unit  - b'01'
; 10101010 <-- stays on for 2 units - b'10'
; 11111111 <-- stays on for 3 units - b'11'

; in0 LEDs 0,1
; in1 LEDs 2,3
; in2 LEDs 4,5
; in3 LED  6

    call         get_next_pattern_entry
    movwf        in0
  
    call         get_next_pattern_entry
    movwf        in1

    call         get_next_pattern_entry     ;4rgb
    movwf        in2                        ;4rgb

    call         get_next_pattern_entry     ;4rgb
    movwf        in3                        ;4rgb



    movf         pspeed,w
    movwf        speed
    call         display_2bit

    return
#endif

#ifdef PATTERN11
;**********************************************************************
table_type_11
;**********************************************************************
; 76543210 <-- bits
; AABBCCDD <-- LEDs
; 01010101 <-- stays on for 1 unit  - b'01'
; 10101010 <-- stays on for 2 units - b'10'
; 11111111 <-- stays on for 3 units - b'11'

; in0 LEDs 0,1,3,4
; in1 LEDs 5,6,C

    call         get_next_pattern_entry
    movwf        in0
  
    call         get_next_pattern_entry
    movwf        in1

    movf         pspeed,w
    movwf        speed
    call         display_2bit

    return
#endif

#ifdef RANDOM

;**********************************************************************
gen_random
;**********************************************************************

   var     random

   RLF     random,W
   RLF     random,W
   BTFSC   random,4
   XORLW   1
   BTFSC   random,5
   XORLW   1
   BTFSC   random,3
   XORLW   1
   MOVWF   random
   return
#endif

#ifdef PATTERN12
;**********************************************************************
table_type_12
;**********************************************************************
;
;  5 bytes
;  00000000 00000000 00111111 11111111 111111XX
;  11223344 55667788 99001122 33445566 778899XX
;  RGRGRGRG RGRGRGRG RGRGRGRG RGRGRGRG RGRGRGXX
;
;  XX = a repeat counter.

    call  gen_random
    movwf        in3
  
    call  gen_random
    movwf        in0

    call  gen_random
    movwf        in2

    call  gen_random
    movwf        in1

    call  gen_random
    movwf        in4

    movfw        pspeed
    call         display_1bit

    return
#endif

#ifdef PATTERN13
;**********************************************************************
table_type_13
;**********************************************************************
;
;  10 bytes
;  11112222 33334444 55556666 77778888 99990000 11112222 33334444 55556666 77778888 9999XXXX   
;
;  XX = a repeat counter.

    call         get_next_pattern_entry
    movwf        in0
  
    call         get_next_pattern_entry
    movwf        in1

    call         get_next_pattern_entry
    movwf        in2

    call         get_next_pattern_entry
    movwf        in3

    call         get_next_pattern_entry
    movwf        in4

    call         get_next_pattern_entry
    movwf        in5

    call         get_next_pattern_entry
    movwf        in6

    call         get_next_pattern_entry
    movwf        in7

    call         get_next_pattern_entry
    movwf        in8

    call         get_next_pattern_entry
    movwf        in9

    movlw        b'00001111'
    andwf        in9,w
    movwf        p2count
    incf         p2count,f
    rlf          p2count,f
    rlf          p2count,f

p3loop
    movfw        pspeed
    call         display_2bit

    decfsz       p2count,f
    goto         p3loop

    return
#endif

#ifdef PATTERN14
;**********************************************************************
table_type_14
;**********************************************************************
;
;  5 bytes
;  11223344 55667788 99001122 33445566 778899XX   
;
;  XX = a repeat counter.

    call         get_next_pattern_entry
    movwf        in0
  
    call         get_next_pattern_entry
    movwf        in1

    call         get_next_pattern_entry
    movwf        in2

    call         get_next_pattern_entry
    movwf        in3

    call         get_next_pattern_entry
    movwf        in4

    movlw        b'00000011'
    andwf        in4,w
    movwf        p2count
    incf         p2count,f
    rlf          p2count,f
    rlf          p2count,f

p3loop
    movfw        pspeed
    call         display_2bit

    decfsz       p2count,f
    goto         p3loop

    return
#endif


#ifdef DISPLAY_1BIT_A
;**********************************************************************
display_1bit  ; Mono 6 LEDs, Badge LED add center (IR) for 7
;**********************************************************************

    movwf        speed              ;w has the speed/delay

	clrf		 Ar_reg
    btfsc        in0,7
    comf         Ar_reg,f
 
	clrf	 	 Ag_reg
    btfsc        in0,5
    comf         Ag_reg,f

	clrf		 Ab_reg
    btfsc        in0,3
	comf		 Ab_reg,f

	clrf		 Cr_reg
    btfsc        in0,6
	comf		 Cr_reg,f
 
	clrf	 	 Cg_reg
    btfsc        in0,4
	comf	 	 Cg_reg,f

	clrf		 Cb_reg
    btfsc        in0,2
	comf		 Cb_reg,f

#ifdef BADGE
	clrf		 Center_reg
    btfsc        in0,1
	comf		 Center_reg,f
#endif

    movf         speed,w
    call         strobe_delay

    return
#endif
#ifdef DISPLAY_1BIT_B
;**********************************************************************
display_1bit ; 19 Circle LEDs (38 LEDs)
;**********************************************************************

    movwf        speed              ;w has the speed/delay

	clrf		 A1_A2_reg        ; 1
	clrf		 A1_C0_reg        ; 2
	clrf		 A2_C0_reg        ; 3
	clrf	 	 A2_C1_reg        ; 4
	clrf		 C0_C1_reg        ; 5
	clrf		 C0_C2_reg        ; 6
	clrf		 C0_C4_reg        ; 7
	clrf		 C1_C4_reg        ; 8
	clrf		 A0_C1_reg        ; 9
	clrf		 A0_C0_reg        ; 10
	clrf		 A0_A2_reg        ; 11
	clrf		 A0_A1_reg        ; 12
	clrf		 A1_C2_reg        ; 13
	clrf	 	 A1_C1_reg        ; 14
	clrf		 A2_C2_reg        ; 15
	clrf		 A2_C4_reg        ; 16
	clrf		 A0_C4_reg        ; 17
	clrf		 A0_C2_reg        ; 18
	clrf		 A1_C4_reg        ; 19
 	clrf		 C1_C2_reg        ; no LED
	clrf		 C2_C4_reg        ; no LED

#ifndef MONO
    movlw        0xf0
    btfsc        in2,1                    ; 12R
	iorwf		 A0_A1_reg,f

    movlw        0xf0
    btfsc        in2,3                    ; 11R
	iorwf		 A0_A2_reg,f

    movlw        0xf0
    btfsc        in2,5                    ; 10R
	iorwf		 A0_C0_reg,f

    movlw        0xf0
    btfsc        in2,7                    ; 9R
	iorwf		 A0_C1_reg,f

    movlw        0xf0
    btfsc        in4,5                    ; 18R
	iorwf		 A0_C2_reg,f

    movlw        0xf0
    btfsc        in4,7                    ; 17R
	iorwf		 A0_C4_reg,f
#endif

    movlw        0x0f
    btfsc        in2,0                    ; 12G
	iorwf	 	 A0_A1_reg,f

#ifndef MONO
    movlw        0xf0
    btfsc        in0,7                    ; 1R
	iorwf		 A1_A2_reg,f

    movlw        0xf0
    btfsc        in0,5                    ; 2R
	iorwf		 A1_C0_reg,f
 
    movlw        0xf0
    btfsc        in3,5
    iorwf        A1_C1_reg,f              ; 14R

    movlw        0xf0
    btfsc        in3,7                    ; 13R
    iorwf		 A1_C2_reg,f

    movlw        0xf0
    btfsc        in4,3                    ; 19R
	iorwf		 A1_C4_reg,f
#endif

    movlw        0x0f
    btfsc        in2,2                    ; 11G
	iorwf	 	 A0_A2_reg,f

    movlw        0x0f
    btfsc        in0,6                    ; 1G
    iorwf         A1_A2_reg,f

#ifndef MONO
    movlw        0xf0
    btfsc        in0,3                    ; 3R
	iorwf		 A2_C0_reg,f

    movlw        0xf0
    btfsc        in0,1                    ; 4R
	iorwf	 	 A2_C1_reg,f

    movlw        0xf0
    btfsc        in3,3                    ; 15R
	iorwf		 A2_C2_reg,f

    movlw        0xf0
    btfsc        in3,1                    ; 16R
	iorwf		 A2_C4_reg,f
#endif

    movlw        0x0f
    btfsc        in2,4                    ; 10G
	iorwf		 A0_C0_reg,f
 
    movlw        0x0f
    btfsc        in0,4                    ; 2G
	iorwf		 A1_C0_reg,f

    movlw        0x0f
    btfsc        in0,2                    ; 3G
	iorwf		 A2_C0_reg,f
 
#ifndef MONO
    movlw        0xf0
    btfsc        in1,7                    ; 5R
	iorwf		 C0_C1_reg,f

    movlw        0xf0
    btfsc        in1,5                    ; 6R
	iorwf		 C0_C2_reg,f
 
    movlw        0xf0
    btfsc        in1,3                    ; 7R
	iorwf		 C0_C4_reg,f
#endif

    movlw        0x0f
    btfsc        in2,6                    ; 9G
	iorwf		 A0_C1_reg,f
 
    movlw        0x0f
    btfsc        in3,4                    ; 14G
	iorwf		 A1_C1_reg,f

    movlw        0x0f
    btfsc        in0,0                    ; 4G
	iorwf		 A2_C1_reg,f
 
    movlw        0x0f
    btfsc        in1,6                    ; 5G
	iorwf		 C0_C1_reg,f

 
#ifndef MONO
    movlw        0xf0
    btfsc        in1,1                    ; 8R
	iorwf		 C1_C4_reg,f
#endif

    movlw        0x0f
    btfsc        in4,4
	iorwf		 A0_C2_reg,f      ; 18G
 
    movlw        0x0f
    btfsc        in3,6                    ; 13G
	iorwf		 A1_C2_reg,f

    movlw        0x0f
    btfsc        in3,2
	iorwf		 A2_C2_reg,f      ; 15G
 
    movlw        0x0f
    btfsc        in1,4                    ; 6G
	iorwf		 C0_C2_reg,f

    movlw        0x0f
    btfsc        in4,6                    ; 17G
	iorwf		 A0_C4_reg,f
 
    movlw        0x0f
    btfsc        in4,2                    ; 19G
	iorwf		 A1_C4_reg,f

    movlw        0x0f
    btfsc        in3,0                    ; 16G
	iorwf		 A2_C4_reg,f
 
    movlw        0x0f
    btfsc        in1,2                    ; 7G
	iorwf		 C0_C4_reg,f

    movlw        0x0f
    btfsc        in1,0
	iorwf		 C1_C4_reg,f      ; 8G
 

    movf         speed,w
    call         strobe_delay

    return
#endif
#ifdef DISPLAY_1BIT_C
;**********************************************************************
display_1bit ; 12 LEDs, BI6 & 4RGB Badge LED add center (IR) for 13
;**********************************************************************

    movwf        speed              ;w has the speed/delay

	clrf		 Ar_reg
    btfsc        in0,7
    comf         Ar_reg,f
 
	clrf	 	 Ag_reg
    btfsc        in0,3
    comf         Ag_reg,f

	clrf		 Ab_reg
    btfsc        in1,7
	comf		 Ab_reg,f

	clrf		 Br_reg
    btfsc        in0,6
	comf		 Br_reg,f
 
	clrf	 	 Bg_reg
    btfsc        in0,2
	comf	 	 Bg_reg,f

	clrf		 Bb_reg
    btfsc        in1,6
	comf		 Bb_reg,f

	clrf		 Cr_reg
    btfsc        in0,5
	comf		 Cr_reg,f
 
	clrf	 	 Cg_reg
    btfsc        in0,1
	comf	 	 Cg_reg,f

	clrf		 Cb_reg
    btfsc        in1,5
	comf		 Cb_reg,f

	clrf		 Dr_reg
    btfsc        in0,4
	comf		 Dr_reg,f
 
	clrf	 	 Dg_reg
    btfsc        in0,0
	comf	 	 Dg_reg,f

	clrf		 Db_reg
    btfsc        in1,4
	comf		 Db_reg,f

#ifdef BADGE
	clrf		 Center_reg
    btfsc        in1,3
	comf		 Center_reg,f
#endif

    movf         speed,w
    call         strobe_delay

    return
#endif
#ifdef DISPLAY_1BIT_D
;**********************************************************************
display_1bit ; 20 LEDs
;**********************************************************************

    movwf        speed              ;w has the speed/delay

	clrf		 A0_A5_reg         ; IR

	clrf		 A5_A0_reg        ; 01
    btfsc        in0,7
	comf		 A5_A0_reg,f

	clrf		 A2_A5_reg        ; 02
    btfsc        in0,6
	comf		 A2_A5_reg,f

	clrf		 A5_A2_reg        ; 03
    btfsc        in0,5
	comf		 A5_A2_reg,f

	clrf		 A4_A5_reg        ; 04
    btfsc        in0,4
	comf		 A4_A5_reg,f

	clrf		 A5_A4_reg        ; 05
    btfsc        in0,3
	comf		 A5_A4_reg,f

	clrf	 	 A1_A5_reg        ; 06
    btfsc        in0,2
	comf	 	 A1_A5_reg,f

	clrf		 A5_A1_reg        ; 07
    btfsc        in0,1
	comf		 A5_A1_reg,f

	clrf		 A2_A0_reg        ; 08
    btfsc        in0,0
	comf		 A2_A0_reg,f
 
	clrf	 	 A0_A2_reg        ; 09
    btfsc        in1,7
    comf         A0_A2_reg,f

	clrf		 A4_A0_reg        ; 10
    btfsc        in1,6
	comf		 A4_A0_reg,f

	clrf		 A0_A4_reg        ; 11
    btfsc        in1,5
	comf		 A0_A4_reg,f
 
	clrf	 	 A1_A0_reg        ; 12
    btfsc        in1,4
	comf	 	 A1_A0_reg,f

	clrf		 A0_A1_reg        ; 13
    btfsc        in1,3
    comf         A0_A1_reg,f

	clrf		 A4_A2_reg        ; 14
    btfsc        in1,2
	comf		 A4_A2_reg,f

	clrf	 	 A2_A4_reg        ; 15
    btfsc        in1,1
	comf	 	 A2_A4_reg,f

	clrf		 A1_A2_reg        ; 16
    btfsc        in1,0
	comf		 A1_A2_reg,f

	clrf		 A2_A1_reg        ; 17
    btfsc        in2,7
	comf		 A2_A1_reg,f

	clrf		 A1_A4_reg        ; 18
    btfsc        in2,6
	comf		 A1_A4_reg,f
 
	clrf		 A4_A1_reg        ; 19
    btfsc        in2,5
	comf		 A4_A1_reg,f


    movf         speed,w
    call         strobe_delay

    return
#endif
#ifdef DISPLAY_2BIT_A
;**********************************************************************
display_2bit
;**********************************************************************
    movf    speed,w             ;enter here if repeat count is in speed
display_w_2bit                      ;enter here if repeat count is in W reg

; 76543210 <-- bits
; AABBCCDD <-- LEDs
; 01010101 <-- stays on for 1 unit  - b'01'
; 10101010 <-- stays on for 2 units - b'10'
; 11111111 <-- stays on for 3 units - b'11'

; in0 LEDs 1,2,3,4
; in1 LEDs 5,6,C


	clrf		 Ar_reg
    movlw        BRIGHT1
    btfsc        in0,6
    addwf        Ar_reg,f
    movlw        BRIGHT2
    btfsc        in0,7
    addwf        Ar_reg,f
 
	clrf	 	 Ag_reg
    movlw        BRIGHT1
    btfsc        in0,2
    addwf        Ag_reg,f
    movlw        BRIGHT2
    btfsc        in0,3
    addwf        Ag_reg,f

	clrf		 Ab_reg
    movlw        BRIGHT1
    btfsc        in1,6
    addwf        Ab_reg,f
    movlw        BRIGHT2
    btfsc        in1,7
    addwf        Ab_reg,f

	clrf		 Cr_reg
    movlw        BRIGHT1
    btfsc        in0,4
    addwf        Cr_reg,f
    movlw        BRIGHT2
    btfsc        in0,5
    addwf        Cr_reg,f
 
	clrf	 	 Cg_reg
    movlw        BRIGHT1
    btfsc        in0,0
    addwf        Cg_reg,f
    movlw        BRIGHT2
    btfsc        in0,1
    addwf        Cg_reg,f

	clrf		 Cb_reg
    movlw        BRIGHT1
    btfsc        in1,4
    addwf        Cb_reg,f
    movlw        BRIGHT2
    btfsc        in1,5
    addwf        Cb_reg,f 

#ifdef BADGE
	clrf		 Center_reg
    movlw        BRIGHT1
    btfsc        in1,2
    addwf        Center_reg,f
    movlw        BRIGHT2
    btfsc        in1,3
    addwf        Center_reg,f 
#endif

    movf         speed,w
    call         strobe_delay
    movf         speed,w
    call         strobe_delay
    movf         speed,w
    call         strobe_delay

    return
#endif

#ifdef DISPLAY_2BIT_C
;**********************************************************************
display_2bit
;**********************************************************************
    movf    speed,w             ;enter here if repeat count is in speed
display_w_2bit                      ;enter here if repeat count is in W reg

; 76543210 <-- bits
; AABBCCDD <-- LEDs
; 01010101 <-- stays on for 1 unit  - b'01'
; 10101010 <-- stays on for 2 units - b'10'
; 11111111 <-- stays on for 3 units - b'11'

; in0 red
; in1 green
; in2 blue

	clrf		 Ar_reg
    movlw        BRIGHT1
    btfsc        in0,6
    addwf        Ar_reg,f
    movlw        BRIGHT2
    btfsc        in0,7
    addwf        Ar_reg,f
 
	clrf	 	 Ag_reg
    movlw        BRIGHT1
    btfsc        in1,6
    addwf        Ag_reg,f
    movlw        BRIGHT2
    btfsc        in1,7
    addwf        Ag_reg,f

	clrf		 Ab_reg
    movlw        BRIGHT1
    btfsc        in2,6
    addwf        Ab_reg,f
    movlw        BRIGHT2
    btfsc        in2,7
    addwf        Ab_reg,f

	clrf		 Br_reg
    movlw        BRIGHT1
    btfsc        in0,4
    addwf        Br_reg,f
    movlw        BRIGHT2
    btfsc        in0,5
    addwf        Br_reg,f
 
	clrf	 	 Bg_reg
    movlw        BRIGHT1
    btfsc        in1,4
    addwf        Bg_reg,f
    movlw        BRIGHT2
    btfsc        in1,5
    addwf        Bg_reg,f

	clrf		 Bb_reg
    movlw        BRIGHT1
    btfsc        in2,4
    addwf        Bb_reg,f
    movlw        BRIGHT2
    btfsc        in2,5
    addwf        Bb_reg,f 

	clrf		 Cr_reg
    movlw        BRIGHT1
    btfsc        in0,2
    addwf        Cr_reg,f
    movlw        BRIGHT2
    btfsc        in0,3
    addwf        Cr_reg,f
 
	clrf	 	 Cg_reg
    movlw        BRIGHT1
    btfsc        in1,2
    addwf        Cg_reg,f
    movlw        BRIGHT2
    btfsc        in1,3
    addwf        Cg_reg,f

	clrf		 Cb_reg
    movlw        BRIGHT1
    btfsc        in2,2
    addwf        Cb_reg,f
    movlw        BRIGHT2
    btfsc        in2,3
    addwf        Cb_reg,f 

	clrf		 Dr_reg
    movlw        BRIGHT1
    btfsc        in0,0
    addwf        Dr_reg,f
    movlw        BRIGHT2
    btfsc        in0,1
    addwf        Dr_reg,f
 
	clrf	 	 Dg_reg
    movlw        BRIGHT1
    btfsc        in1,0
    addwf        Dg_reg,f
    movlw        BRIGHT2
    btfsc        in1,1
    addwf        Dg_reg,f

	clrf		 Db_reg
    movlw        BRIGHT1
    btfsc        in2,0
    addwf        Db_reg,f
    movlw        BRIGHT2
    btfsc        in2,1
    addwf        Db_reg,f 

#ifdef BADGE
	clrf		 Center_reg
    movlw        BRIGHT1
    btfsc        in3,6
    addwf        Center_reg,f
    movlw        BRIGHT2
    btfsc        in3,7
    addwf        Center_reg,f 
#endif

    movf         speed,w
    call         strobe_delay
    movf         speed,w
    call         strobe_delay
    movf         speed,w
    call         strobe_delay

    return
#endif

#define BRIGHT1H 0xA0
#define BRIGHT2H 0x40
#define BRIGHT1L 0x0A
#define BRIGHT2L 0x04


#ifdef DISPLAY_2BIT_D
;**********************************************************************
display_2bit ; 19 Circle LEDs (38 LEDs)
;**********************************************************************

    movwf        speed              ;w has the speed/delay

	clrf		 A1_A2_reg        ; 1
	clrf		 A1_C0_reg        ; 2
	clrf		 A2_C0_reg        ; 3
	clrf	 	 A2_C1_reg        ; 4
	clrf		 C0_C1_reg        ; 5
	clrf		 C0_C2_reg        ; 6
	clrf		 C0_C4_reg        ; 7
	clrf		 C1_C4_reg        ; 8
	clrf		 A0_C1_reg        ; 9
	clrf		 A0_C0_reg        ; 10
	clrf		 A0_A2_reg        ; 11
	clrf		 A0_A1_reg        ; 12
	clrf		 A1_C2_reg        ; 13
	clrf	 	 A1_C1_reg        ; 14
	clrf		 A2_C2_reg        ; 15
	clrf		 A2_C4_reg        ; 16
	clrf		 A0_C4_reg        ; 17
	clrf		 A0_C2_reg        ; 18
	clrf		 A1_C4_reg        ; 19
 	clrf		 C1_C2_reg        ; no LED
	clrf		 C2_C4_reg        ; no LED

    movlw        BRIGHT1H
    btfsc        in0,7                    ; 1R (high bit)
	addwf		 A1_A2_reg,f
    movlw        BRIGHT2H
    btfsc        in0,6                    ; 1R (low bit)
	addwf		 A1_A2_reg,f

    movlw        BRIGHT1L
    btfsc        in0,5                    ; 1G (high bit)
	addwf		 A1_A2_reg,f
    movlw        BRIGHT2L
    btfsc        in0,4                    ; 1G (low bit)
	addwf		 A1_A2_reg,f

    movlw        BRIGHT1H
    btfsc        in0,3                    ; 2R (high bit)
	addwf		 A1_C0_reg,f
    movlw        BRIGHT2H
    btfsc        in0,2                    ; 2R (low bit)
	addwf		 A1_C0_reg,f

    movlw        BRIGHT1L
    btfsc        in0,1                    ; 2G (high bit)
	addwf		 A1_C0_reg,f
    movlw        BRIGHT2L
    btfsc        in0,0                    ; 2G (low bit)
	addwf		 A1_C0_reg,f

    movlw        BRIGHT1H
    btfsc        in1,7                    ; 3R (high bit)
	addwf		 A2_C0_reg,f
    movlw        BRIGHT2H
    btfsc        in1,6                    ; 3R (low bit)
	addwf		 A2_C0_reg,f

    movlw        BRIGHT1L
    btfsc        in1,5                    ; 3G (high bit)
	addwf		 A2_C0_reg,f
    movlw        BRIGHT2L
    btfsc        in1,4                    ; 3G (low bit)
	addwf		 A2_C0_reg,f

    movlw        BRIGHT1H
    btfsc        in1,3                    ; 4R (high bit)
	addwf		 A2_C1_reg,f
    movlw        BRIGHT2H
    btfsc        in1,2                    ; 4R (low bit)
	addwf		 A2_C1_reg,f

    movlw        BRIGHT1L
    btfsc        in1,1                    ; 4G (high bit)
	addwf		 A2_C1_reg,f
    movlw        BRIGHT2L
    btfsc        in1,0                    ; 4G (low bit)
	addwf		 A2_C1_reg,f

    movlw        BRIGHT1H
    btfsc        in2,7                    ; 5R (high bit)
	addwf		 C0_C1_reg,f
    movlw        BRIGHT2H
    btfsc        in2,6                    ; 5R (low bit)
	addwf		 C0_C1_reg,f

    movlw        BRIGHT1L
    btfsc        in2,5                    ; 5G (high bit)
	addwf		 C0_C1_reg,f
    movlw        BRIGHT2L
    btfsc        in2,4                    ; 5G (low bit)
	addwf		 C0_C1_reg,f

    movlw        BRIGHT1H
    btfsc        in2,3                    ; 6R (high bit)
	addwf		 C0_C2_reg,f
    movlw        BRIGHT2H
    btfsc        in2,2                    ; 6R (low bit)
	addwf		 C0_C2_reg,f

    movlw        BRIGHT1L
    btfsc        in2,1                    ; 6G (high bit)
	addwf		 C0_C2_reg,f
    movlw        BRIGHT2L
    btfsc        in2,0                    ; 6G (low bit)
	addwf		 C0_C2_reg,f

    movlw        BRIGHT1H
    btfsc        in3,7                    ; 7R (high bit)
	addwf		 C0_C4_reg,f
    movlw        BRIGHT2H
    btfsc        in3,6                    ; 7R (low bit)
	addwf		 C0_C4_reg,f

    movlw        BRIGHT1L
    btfsc        in3,5                    ; 7G (high bit)
	addwf		 C0_C4_reg,f
    movlw        BRIGHT2L
    btfsc        in3,4                    ; 7G (low bit)
	addwf		 C0_C4_reg,f

    movlw        BRIGHT1H
    btfsc        in3,3                    ; 8R (high bit)
	addwf		 C1_C4_reg,f
    movlw        BRIGHT2H
    btfsc        in3,2                    ; 8R (low bit)
	addwf		 C1_C4_reg,f

    movlw        BRIGHT1L
    btfsc        in3,1                    ; 8G (high bit)
	addwf		 C1_C4_reg,f
    movlw        BRIGHT2L
    btfsc        in3,0                    ; 8G (low bit)
	addwf		 C1_C4_reg,f

    movlw        BRIGHT1H
    btfsc        in4,7                    ; 9R (high bit)
	addwf		 A0_C1_reg,f
    movlw        BRIGHT2H
    btfsc        in4,6                    ; 9R (low bit)
	addwf		 A0_C1_reg,f

    movlw        BRIGHT1L
    btfsc        in4,5                    ; 9G (high bit)
	addwf		 A0_C1_reg,f
    movlw        BRIGHT2L
    btfsc        in4,4                    ; 9G (low bit)
	addwf		 A0_C1_reg,f

    movlw        BRIGHT1H
    btfsc        in4,3                    ; 10R (high bit)
	addwf		 A0_C0_reg,f
    movlw        BRIGHT2H
    btfsc        in4,2                    ; 10R (low bit)
	addwf		 A0_C0_reg,f

    movlw        BRIGHT1L
    btfsc        in4,1                    ; 10G (high bit)
	addwf		 A0_C0_reg,f
    movlw        BRIGHT2L
    btfsc        in4,0                    ; 10G (low bit)
	addwf		 A0_C0_reg,f

    movlw        BRIGHT1H
    btfsc        in5,7                    ; 11R (high bit)
	addwf		 A0_A2_reg,f
    movlw        BRIGHT2H
    btfsc        in5,6                    ; 11R (low bit)
	addwf		 A0_A2_reg,f

    movlw        BRIGHT1L
    btfsc        in5,5                    ; 11G (high bit)
	addwf		 A0_A2_reg,f
    movlw        BRIGHT2L
    btfsc        in5,4                    ; 11G (low bit)
	addwf		 A0_A2_reg,f

    movlw        BRIGHT1H
    btfsc        in5,3                    ; 12R (high bit)
	addwf		 A0_A1_reg,f
    movlw        BRIGHT2H
    btfsc        in5,2                    ; 12R (low bit)
	addwf		 A0_A1_reg,f

    movlw        BRIGHT1L
    btfsc        in5,1                    ; 12G (high bit)
	addwf		 A0_A1_reg,f
    movlw        BRIGHT2L
    btfsc        in5,0                    ; 12G (low bit)
	addwf		 A0_A1_reg,f

    movlw        BRIGHT1H
    btfsc        in6,7                    ; 13R (high bit)
	addwf		 A1_C2_reg,f
    movlw        BRIGHT2H
    btfsc        in6,6                    ; 13R (low bit)
	addwf		 A1_C2_reg,f

    movlw        BRIGHT1L
    btfsc        in6,5                    ; 13G (high bit)
	addwf		 A1_C2_reg,f
    movlw        BRIGHT2L
    btfsc        in6,4                    ; 13G (low bit)
	addwf		 A1_C2_reg,f

    movlw        BRIGHT1H
    btfsc        in6,3                    ; 14R (high bit)
	addwf		 A1_C1_reg,f 
    movlw        BRIGHT2H
    btfsc        in6,2                    ; 14R (low bit)
	addwf		 A1_C1_reg,f 

    movlw        BRIGHT1L
    btfsc        in6,1                    ; 14G (high bit)
	addwf		 A1_C1_reg,f 
    movlw        BRIGHT2L
    btfsc        in6,0                    ; 14G (low bit)
	addwf		 A1_C1_reg,f 

    movlw        BRIGHT1H
    btfsc        in7,7                    ; 15R (high bit)
	addwf		 A2_C2_reg,f
    movlw        BRIGHT2H
    btfsc        in7,6                    ; 15R (low bit)
	addwf		 A2_C2_reg,f

    movlw        BRIGHT1L
    btfsc        in7,5                    ; 15G (high bit)
	addwf		 A2_C2_reg,f
    movlw        BRIGHT2L
    btfsc        in7,4                    ; 15G (low bit)
	addwf		 A2_C2_reg,f

    movlw        BRIGHT1H
    btfsc        in7,3                    ; 16R (high bit)
	addwf		 A2_C4_reg,f
    movlw        BRIGHT2H
    btfsc        in7,2                    ; 16R (low bit)
	addwf		 A2_C4_reg,f

    movlw        BRIGHT1L
    btfsc        in7,1                    ; 16G (high bit)
	addwf		 A2_C4_reg,f
    movlw        BRIGHT2L
    btfsc        in7,0                    ; 16G (low bit)
	addwf		 A2_C4_reg,f

    movlw        BRIGHT1H
    btfsc        in8,7                    ; 17R (high bit)
	addwf		 A0_C4_reg,f
    movlw        BRIGHT2H
    btfsc        in8,6                    ; 17R (low bit)
	addwf		 A0_C4_reg,f

    movlw        BRIGHT1L
    btfsc        in8,5                    ; 17G (high bit)
	addwf		 A0_C4_reg,f
    movlw        BRIGHT2L
    btfsc        in8,4                    ; 17G (low bit)
	addwf		 A0_C4_reg,f

    movlw        BRIGHT1H
    btfsc        in8,3                    ; 18R (high bit)
	addwf		 A0_C2_reg,f
    movlw        BRIGHT2H
    btfsc        in8,2                    ; 18R (low bit)
	addwf		 A0_C2_reg,f

    movlw        BRIGHT1L
    btfsc        in8,1                    ; 18G (high bit)
	addwf		 A0_C2_reg,f
    movlw        BRIGHT2L
    btfsc        in8,0                    ; 18G (low bit)
	addwf		 A0_C2_reg,f

    movlw        BRIGHT1H
    btfsc        in9,7                    ; 19R (high bit)
	addwf		 A1_C4_reg,f
    movlw        BRIGHT2H
    btfsc        in9,6                    ; 19R (low bit)
	addwf		 A1_C4_reg,f

    movlw        BRIGHT1L
    btfsc        in9,5                    ; 19G (high bit)
	addwf		 A1_C4_reg,f
    movlw        BRIGHT2L
    btfsc        in9,4                    ; 19G (low bit)
	addwf		 A1_C4_reg,f
 
    movf         speed,w
    call         strobe_delay

    return
#endif

#ifdef DISPLAY_2BIT_E
;**********************************************************************
display_2bit ; 19 Circle LEDs (38 LEDs)
;**********************************************************************

    movwf        speed              ;w has the speed/delay

	clrf		 A1_A2_reg        ; 1
	clrf		 A1_C0_reg        ; 2
	clrf		 A2_C0_reg        ; 3
	clrf	 	 A2_C1_reg        ; 4
	clrf		 C0_C1_reg        ; 5
	clrf		 C0_C2_reg        ; 6
	clrf		 C0_C4_reg        ; 7
	clrf		 C1_C4_reg        ; 8
	clrf		 A0_C1_reg        ; 9
	clrf		 A0_C0_reg        ; 10
	clrf		 A0_A2_reg        ; 11
	clrf		 A0_A1_reg        ; 12
	clrf		 A1_C2_reg        ; 13
	clrf	 	 A1_C1_reg        ; 14
	clrf		 A2_C2_reg        ; 15
	clrf		 A2_C4_reg        ; 16
	clrf		 A0_C4_reg        ; 17
	clrf		 A0_C2_reg        ; 18
	clrf		 A1_C4_reg        ; 19
 	clrf		 C1_C2_reg        ; no LED
	clrf		 C2_C4_reg        ; no LED

    movlw        BRIGHT1L
    btfsc        in0,7                    ; 1R (high bit)
	addwf		 A1_A2_reg,f
    movlw        BRIGHT2L
    btfsc        in0,6                    ; 1R (low bit)
	addwf		 A1_A2_reg,f


    movlw        BRIGHT1L
    btfsc        in0,5                    ; 2R (high bit)
	addwf		 A1_C0_reg,f
    movlw        BRIGHT2L
    btfsc        in0,4                    ; 2R (low bit)
	addwf		 A1_C0_reg,f

    movlw        BRIGHT1L
    btfsc        in0,3                    ; 3R (high bit)
	addwf		 A2_C0_reg,f
    movlw        BRIGHT2L
    btfsc        in0,2                    ; 3R (low bit)
	addwf		 A2_C0_reg,f

    movlw        BRIGHT1L
    btfsc        in0,1                    ; 4R (high bit)
	addwf		 A2_C1_reg,f
    movlw        BRIGHT2L
    btfsc        in0,0                    ; 4R (low bit)
	addwf		 A2_C1_reg,f

    movlw        BRIGHT1L
    btfsc        in1,7                    ; 5R (high bit)
	addwf		 C0_C1_reg,f
    movlw        BRIGHT2L
    btfsc        in1,6                    ; 5R (low bit)
	addwf		 C0_C1_reg,f

    movlw        BRIGHT1L
    btfsc        in1,5                    ; 6R (high bit)
	addwf		 C0_C2_reg,f
    movlw        BRIGHT2L
    btfsc        in1,4                    ; 6R (low bit)
	addwf		 C0_C2_reg,f

    movlw        BRIGHT1L
    btfsc        in1,3                    ; 7R (high bit)
	addwf		 C0_C4_reg,f
    movlw        BRIGHT2L
    btfsc        in1,2                    ; 7R (low bit)
	addwf		 C0_C4_reg,f

    movlw        BRIGHT1L
    btfsc        in1,1                    ; 8R (high bit)
	addwf		 C1_C4_reg,f
    movlw        BRIGHT2L
    btfsc        in1,0                    ; 8R (low bit)
	addwf		 C1_C4_reg,f

    movlw        BRIGHT1L
    btfsc        in2,7                    ; 9R (high bit)
	addwf		 A0_C1_reg,f
    movlw        BRIGHT2L
    btfsc        in2,6                    ; 9R (low bit)
	addwf		 A0_C1_reg,f

    movlw        BRIGHT1L
    btfsc        in2,5                    ; 10R (high bit)
	addwf		 A0_C0_reg,f
    movlw        BRIGHT2L
    btfsc        in2,4                    ; 10R (low bit)
	addwf		 A0_C0_reg,f

    movlw        BRIGHT1L
    btfsc        in2,3                    ; 11R (high bit)
	addwf		 A0_A2_reg,f
    movlw        BRIGHT2L
    btfsc        in2,2                    ; 11R (low bit)
	addwf		 A0_A2_reg,f

    movlw        BRIGHT1L
    btfsc        in2,1                    ; 12R (high bit)
	addwf		 A0_A1_reg,f
    movlw        BRIGHT2L
    btfsc        in2,0                    ; 12R (low bit)
	addwf		 A0_A1_reg,f

    movlw        BRIGHT1L
    btfsc        in3,7                    ; 13R (high bit)
	addwf		 A1_C2_reg,f
    movlw        BRIGHT2L
    btfsc        in3,6                    ; 13R (low bit)
	addwf		 A1_C2_reg,f

    movlw        BRIGHT1L
    btfsc        in3,5                    ; 14R (high bit)
	addwf		 A1_C1_reg,f 
    movlw        BRIGHT2L
    btfsc        in3,4                    ; 14R (low bit)
	addwf		 A1_C1_reg,f 

    movlw        BRIGHT1L
    btfsc        in3,3                    ; 15R (high bit)
	addwf		 A2_C2_reg,f
    movlw        BRIGHT2L
    btfsc        in3,2                    ; 15R (low bit)
	addwf		 A2_C2_reg,f

    movlw        BRIGHT1L
    btfsc        in3,1                    ; 16R (high bit)
	addwf		 A2_C4_reg,f
    movlw        BRIGHT2L
    btfsc        in3,0                    ; 16R (low bit)
	addwf		 A2_C4_reg,f

    movlw        BRIGHT1L
    btfsc        in4,7                    ; 17R (high bit)
	addwf		 A0_C4_reg,f
    movlw        BRIGHT2L
    btfsc        in4,6                    ; 17R (low bit)
	addwf		 A0_C4_reg,f

    movlw        BRIGHT1L
    btfsc        in4,5                    ; 18R (high bit)
	addwf		 A0_C2_reg,f
    movlw        BRIGHT2L
    btfsc        in4,4                    ; 18R (low bit)
	addwf		 A0_C2_reg,f

    movlw        BRIGHT1L
    btfsc        in4,3                    ; 19R (high bit)
	addwf		 A1_C4_reg,f
    movlw        BRIGHT2L
    btfsc        in4,2                    ; 19R (low bit)
	addwf		 A1_C4_reg,f
 
    movf         speed,w
    call         strobe_delay

    return
#endif

;**********************************************************************
;   IR Tester
;**********************************************************************
IR_Tester
itop
    movlw        0x02
    subwf        instate,w
    btfss        STATUS,C
    clrw
    movwf        in0
    
    movlw        0x00
    movwf        in1

    movlw        0x01
    call         display_1bit       

;
;   Check for push button
;
    btfss       button,0
    goto        iloop1
    clrf        max_instate
    clrf        instate

    movf        scount,w                    ; F22
    addlw       0                           ; F23
    btfss       STATUS,Z                    ; F24
    goto        iloop1    

    clrf        in0
    clrf        in1
    comf        in1,f

    movlw       0xFF
    call        display_1bit

;   send an IR signel
    clrf        out_address                 ; address 0x00 "TV remote"
    movlw       0x0c
    movwf       out_command                 ; code 0x0c (on/off)
    call        rf_command_out

;
;   Check for IR Command
;
iloop1
    btfss       IR_in_good,0
    goto        itop
    clrf        IR_in_good

;  flash all LEDs Red
    movlw       0xF0
    movwf       in0
    clrf        in1

    movlw       0x7f
    call        display_1bit    

;   flash all LEDs off
    clrf        in0
    clrf        in1

    movlw       0x3f
    call        display_1bit

;   flash all LEDs Red
    movlw       0xF0
    movwf       in0
    clrf        in1

    movlw       0x7f
    call        display_1bit

;   display command and address
    movf        command,w
    movwf       in0
    movf        address,w
    movwf       in1

    movlw       0xff
    call        display_1bit
    movlw       0xff
    call        display_1bit
    clrf        max_instate
    clrf        instate

    goto        itop


;
; M A I N
;
;**********************************************************************
main
;**********************************************************************

    clrf        PORTA
    clrf        TMR0 
    clrf        pattern
    clrf        scount
    clrf        toggle
    clrf        address
    clrf        command
    clrf        IR_lhalf
    clrf        instate
    clrf        max_instate
    clrf        IR_in_good
    clrf        dcycle
#ifdef PATTERN2
    clrf         delay1
    clrf         fad
    clrf         color
#endif
#ifndef C19
#ifdef MONO
	clrf Br_reg
	clrf Bg_reg
	clrf Bb_reg
	clrf Dr_reg
	clrf Dg_reg
	clrf Db_reg
#endif
#endif

    movlw   0x07
    movwf   CMCON0      ;turn off comparator

    setbank1

; set up TMR0 & pullups
;             +---------- disable pullups (1)
;             |+--------- interrupt edge select (don't care)
;             ||+-------- TMR0 source = internal clock (0)
;             |||+------- TMR0 source edge select (don't care)
;             ||||+------ assign prescaler to TMR0 (0)
;             |||||+++--- prescaler set to 8X (010)
;             |||||||| 
    movlw   b'10000010'
    movwf   OPTION_REG

#ifdef C19
;   enable pullups on portA
    bcf         OPTION_REG,NOT_RAPU

;   input on A5
    clrf         WPUA       ; disable all pullups
    bsf          WPUA,5     ; enable pullup A5
#endif

    movlw   b'01110000'     ;switch to 8 MHz clock
    iorwf   OSCCON,f

    clrf    ANSEL           ;set pins to digital

#ifdef __16F688 
;   setup timer0
;    bcf         OPTION_REG,T0CS
#endif

    setbank0

    clrf        button

#ifdef RANDOM
    movlw       0x1D
    movwf       random
#endif

;   enable timer0 interupt
    bsf     INTCON,T0IE
    bsf     INTCON,GIE

loop_ddf
;  flash all LEDs on     This kills some time, allowing us to sample the button and IR-Rx
    movlw   b'11111111'

    movwf   in0
    movwf   in1
    movwf   in2
#ifdef C19
    movwf   in3
    movwf   in4
#endif

    movlw   0xff
    call    display_1bit 


; Trun all the LEDs off
    clrf   in0
    clrf   in1
    clrf   in2
#ifdef C19
    clrf   in3
    clrf   in4
#endif

    movlw   0xff
    call    display_1bit 

;   if button pressed durring powerup run IR_Tester
;   else run pattern driver
;
    btfss       button,0          
    goto        pattern_driver
    call        toggle_demo
#ifdef ENABLE_IR
    goto        IR_Tester
#else
    goto        pattern_driver
#endif

;**********************************************************************
table_lookup
;**********************************************************************
    movf         tbl_hi,w
    movwf        PCLATH
    movf         pindex,w
    addwf        tbl_low,w
    btfsc        STATUS,0     ; check carry flag
    incf         PCLATH,f
    movwf        PCL

;**********************************************************************
MasterTable
;**********************************************************************
    make_mtab NUM_TAB



;**********************************************************************
table0  ; dummy entry, actual data for pattern 0 is in the EEPROM
;**********************************************************************

#ifdef RGB4
#include <4rgb_patterns.asm>
#endif
#ifdef BI6
#ifdef MONO
#ifdef BADGE
#include <6led+c_patterns.asm>
#else
#include <6led_patterns.asm>
#endif
#else
#ifdef BADGE
#include <6bi+c_patterns.asm>
#else
#include <6bi_patterns.asm>
#endif
#endif
#endif
#ifdef S19
#include <19led_stick_patterns.asm>
#endif
#ifdef C19
#ifdef MONO
#include <19mono_circle_patterns.asm>
#else
#include <19bi_circle_patterns.asm>
#endif
#endif

    END             ; directive 'end of program'
